/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.utils.ClusterGenerator;
import voldemort.utils.ClusterNodeDescriptor;
import voldemort.utils.Ec2Connection;
import voldemort.utils.Ec2ConnectionListener;
import voldemort.utils.Ec2RemoteTestConfig;
import voldemort.utils.HostNamePair;
import voldemort.utils.impl.TypicaEc2Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ec2RemoteTestUtils {
    public static List<HostNamePair> createInstances(Ec2RemoteTestConfig ec2Config) throws Exception {
        return Ec2RemoteTestUtils.createInstances(ec2Config.getInstanceCount(), ec2Config);
    }

    public static List<HostNamePair> createInstances(int instanceCount, Ec2RemoteTestConfig ec2Config) throws Exception {
        TypicaEc2Connection ec2 = new TypicaEc2Connection(ec2Config.getAccessId(), ec2Config.getSecretKey(), new Ec2Listener(ec2Config.getInstanceIdFile()));
        return ec2.createInstances(ec2Config.getAmi(), ec2Config.getKeyPairId(), Ec2Connection.Ec2InstanceType.DEFAULT, instanceCount, null);
    }

    public static void destroyInstances(List<String> hostNames, Ec2RemoteTestConfig ec2Config) throws Exception {
        TypicaEc2Connection ec2 = new TypicaEc2Connection(ec2Config.getAccessId(), ec2Config.getSecretKey(), new Ec2Listener(ec2Config.getInstanceIdFile()));
        ec2.deleteInstancesByHostName(hostNames);
    }

    public static List<HostNamePair> listInstances(Ec2RemoteTestConfig ec2Config) throws Exception {
        TypicaEc2Connection ec2 = new TypicaEc2Connection(ec2Config.getAccessId(), ec2Config.getSecretKey());
        return ec2.list();
    }

    public static Map<String, Integer> generateClusterDescriptor(List<HostNamePair> hostNamePairs, String clusterName, String path) throws Exception {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getInternalHostName());
        }
        ClusterGenerator clusterGenerator = new ClusterGenerator();
        List<ClusterNodeDescriptor> nodes = clusterGenerator.createClusterNodeDescriptors(hostNames, 3);
        String clusterXml = clusterGenerator.createClusterDescriptor(clusterName, nodes);
        FileUtils.writeStringToFile((File)new File(path), (String)clusterXml);
        HashMap<String, Integer> nodeIds = new HashMap<String, Integer>();
        for (ClusterNodeDescriptor node : nodes) {
            for (HostNamePair hostNamePair : hostNamePairs) {
                if (!node.getHostName().equals(hostNamePair.getInternalHostName())) continue;
                nodeIds.put(hostNamePair.getExternalHostName(), node.getId());
            }
        }
        return nodeIds;
    }

    private static class Ec2Listener
    implements Ec2ConnectionListener {
        private final File file;
        private final Logger logger = Logger.getLogger(this.getClass());

        public Ec2Listener(File file) {
            this.file = file;
        }

        public synchronized void instanceCreated(String instanceId) {
            block3: {
                try {
                    List<String> instanceIds = this.file.exists() ? FileUtils.readLines((File)this.file) : new ArrayList();
                    instanceIds.add(instanceId);
                    FileUtils.writeLines((File)this.file, instanceIds);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Instances created: " + FileUtils.readLines((File)this.file)));
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
        }

        public synchronized void instanceDestroyed(String instanceId) {
            block4: {
                try {
                    List instanceIds = this.file.exists() ? FileUtils.readLines((File)this.file) : new ArrayList();
                    Iterator i = instanceIds.iterator();
                    while (i.hasNext()) {
                        if (!instanceId.equals(((String)i.next()).trim())) continue;
                        i.remove();
                    }
                    FileUtils.writeLines((File)this.file, instanceIds);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Instances remaining: " + FileUtils.readLines((File)this.file)));
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.ERROR)) break block4;
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

