/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import voldemort.Attempt;
import voldemort.TestUtils;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.utils.Ec2RemoteTestConfig;
import voldemort.utils.Ec2RemoteTestUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.Pair;
import voldemort.utils.RemoteTestUtils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ec2GossipTest {
    private static Ec2GossipTestConfig ec2GossipTestConfig;
    private static List<HostNamePair> hostNamePairs;
    private static List<String> hostNames;
    private static Map<String, Integer> nodeIds;
    private static final Logger logger;

    @BeforeClass
    public static void setUpClass() throws Exception {
        ec2GossipTestConfig = new Ec2GossipTestConfig();
        hostNamePairs = Ec2RemoteTestUtils.createInstances(ec2GossipTestConfig);
        hostNames = RemoteTestUtils.toHostNames(hostNamePairs);
        nodeIds = RemoteTestUtils.generateClusterDescriptor(hostNamePairs, "test", ec2GossipTestConfig, true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Sleeping for 30 seconds to give EC2 instances some time to complete startup");
        }
        Thread.sleep(30000L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (hostNames != null) {
            Ec2RemoteTestUtils.destroyInstances(hostNames, ec2GossipTestConfig);
        }
    }

    @Before
    public void setUp() throws Exception {
        RemoteTestUtils.deploy(hostNames, ec2GossipTestConfig);
        RemoteTestUtils.startClusterAsync(hostNames, ec2GossipTestConfig, nodeIds);
    }

    @After
    public void tearDown() throws Exception {
        RemoteTestUtils.stopClusterQuiet(hostNames, ec2GossipTestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGossip() throws Exception {
        try {
            HashSet<String> oldHostnames = new HashSet<String>(hostNames);
            final HashSet<Integer> oldNodeIdSet = new HashSet<Integer>(nodeIds.values());
            HashMap<String, Integer> oldNodeIdMap = new HashMap<String, Integer>(nodeIds);
            logger.info((Object)("Cluster before expanding: " + nodeIds));
            Pair<List<Integer>, List<String>> pair = Ec2GossipTest.expandCluster();
            final List newNodeIds = (List)pair.getFirst();
            List newHostnames = (List)pair.getSecond();
            Assert.assertEquals((String)"correct number of nodes added", (long)newNodeIds.size(), (long)ec2GossipTestConfig.numNewNodes);
            boolean containsOldHostnames = false;
            for (String newHostname : newHostnames) {
                if (!oldHostnames.contains(newHostname)) continue;
                containsOldHostnames = true;
                break;
            }
            boolean containsOldNodeIds = false;
            for (Integer newNodeId : newNodeIds) {
                if (!oldNodeIdSet.contains(newNodeId)) continue;
                containsOldNodeIds = true;
                break;
            }
            Assert.assertFalse((String)"none of the new nodes is an old hostname", (boolean)containsOldHostnames);
            Assert.assertFalse((String)"none of the new nodes is an old node id", (boolean)containsOldNodeIds);
            for (String oldHostname : oldHostnames) {
                Assert.assertEquals((String)("hostname to nodeId mapping preserved for " + oldHostname), oldNodeIdMap.get(oldHostname), (Object)nodeIds.get(oldHostname));
            }
            int peerNodeId = (Integer)Iterables.find(nodeIds.values(), (Predicate)new Predicate<Integer>(){

                public boolean apply(Integer input) {
                    return !newNodeIds.contains(input);
                }
            });
            logger.info((Object)("Select a peer node " + peerNodeId));
            for (String hostname : newHostnames) {
                int nodeId = nodeIds.get(hostname);
                AdminClient adminClient = new AdminClient("tcp://" + hostname + ":6666", new AdminClientConfig());
                Versioned versioned = adminClient.getRemoteMetadata(nodeId, "cluster.xml");
                Version version = versioned.getVersion();
                VectorClock vectorClock = (VectorClock)version;
                vectorClock.incrementVersion(nodeId, System.currentTimeMillis());
                try {
                    adminClient.updateRemoteMetadata(peerNodeId, "cluster.xml", versioned);
                    adminClient.updateRemoteMetadata(nodeId, "cluster.xml", versioned);
                }
                catch (VoldemortException e) {
                    logger.error((Object)e);
                }
            }
            TestUtils.assertWithBackoff((long)1000L, (long)60000L, (Attempt)new Attempt(){
                private int count = 1;
                private AdminClient adminClient = new AdminClient("tcp://" + (String)Ec2GossipTest.access$200().get(0) + ":6666", new AdminClientConfig());

                public void checkCondition() throws Exception, AssertionError {
                    logger.info((Object)("Attempt " + this.count++));
                    Iterator i$ = oldNodeIdSet.iterator();
                    while (i$.hasNext()) {
                        int testNodeId = (Integer)i$.next();
                        logger.info((Object)("Testing node " + testNodeId));
                        try {
                            ClusterMapper clusterMapper = new ClusterMapper();
                            Versioned clusterXml = this.adminClient.getRemoteMetadata(testNodeId, "cluster.xml");
                            Cluster cluster = clusterMapper.readCluster((Reader)new StringReader((String)clusterXml.getValue()));
                            HashSet<Integer> allNodeIds = new HashSet<Integer>();
                            for (Node node : cluster.getNodes()) {
                                allNodeIds.add(node.getId());
                            }
                            Assert.assertTrue((String)("all nodes nodes discovered by node id " + testNodeId), (boolean)allNodeIds.containsAll(nodeIds.values()));
                        }
                        catch (VoldemortException e) {
                            Assert.fail((String)("caught exception " + (Object)((Object)e)));
                        }
                    }
                }
            });
        }
        finally {
            RemoteTestUtils.stopCluster(hostNames, ec2GossipTestConfig);
        }
    }

    private static Pair<List<Integer>, List<String>> expandCluster() throws Exception {
        List<HostNamePair> newInstances = Ec2RemoteTestUtils.createInstances(ec2GossipTestConfig.numNewNodes, ec2GossipTestConfig);
        List<String> newHostnames = RemoteTestUtils.toHostNames(newInstances);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Sleeping for 15 seconds to let new instances startup");
        }
        Thread.sleep(15000L);
        hostNamePairs.addAll(newInstances);
        hostNames = RemoteTestUtils.toHostNames(hostNamePairs);
        nodeIds = RemoteTestUtils.generateClusterDescriptor(hostNamePairs, "test", ec2GossipTestConfig, true);
        logger.info((Object)("Expanded the cluster. New layout: " + nodeIds));
        RemoteTestUtils.deploy(newHostnames, ec2GossipTestConfig);
        RemoteTestUtils.startClusterAsync(newHostnames, ec2GossipTestConfig, nodeIds);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Sleeping for 15 seconds to start voldemort on the new nodes");
        }
        Thread.sleep(15000L);
        return new Pair((Object)Lists.transform(newHostnames, (Function)new Function<String, Integer>(){

            public Integer apply(String hostname) {
                return (Integer)nodeIds.get(hostname);
            }
        }), newHostnames);
    }

    static /* synthetic */ List access$200() {
        return hostNames;
    }

    static {
        logger = Logger.getLogger(Ec2GossipTest.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ec2GossipTestConfig
    extends Ec2RemoteTestConfig {
        private int numNewNodes;

        private Ec2GossipTestConfig() {
        }

        @Override
        protected void init(Properties properties) {
            super.init(properties);
            this.numNewNodes = this.getIntProperty(properties, "gossipNumNewNodes");
        }

        @Override
        protected List<String> getRequiredPropertyNames() {
            List<String> requireds = super.getRequiredPropertyNames();
            requireds.addAll(Arrays.asList("gossipNumNewNodes"));
            return requireds;
        }
    }
}

