/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import voldemort.client.ClientConfig;
import voldemort.client.SocketStoreClientFactory;
import voldemort.client.StoreClient;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.utils.Ec2RemoteTestConfig;
import voldemort.utils.Ec2RemoteTestUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.RemoteTestConfig;
import voldemort.utils.RemoteTestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ec2FailureDetectorTest {
    private static Ec2FailureDetectorTestConfig ec2FailureDetectorTestConfig;
    private static List<HostNamePair> hostNamePairs;
    private static List<String> hostNames;
    private static Map<String, Integer> nodeIds;
    private FailureDetector failureDetector;
    private StoreClient<String, String> store;
    private static final Logger logger;

    @BeforeClass
    public static void setUpClass() throws Exception {
        ec2FailureDetectorTestConfig = new Ec2FailureDetectorTestConfig();
        if (ec2FailureDetectorTestConfig.getInstanceCount() > 0) {
            hostNamePairs = Ec2RemoteTestUtils.createInstances(ec2FailureDetectorTestConfig);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Sleeping for 30 seconds to give EC2 instances some time to complete startup");
            }
            Thread.sleep(30000L);
        } else {
            hostNamePairs = Arrays.asList(new HostNamePair("localhost", "localhost"));
        }
        hostNames = RemoteTestUtils.toHostNames(hostNamePairs);
        nodeIds = RemoteTestUtils.generateClusterDescriptor(hostNamePairs, "test", (RemoteTestConfig)ec2FailureDetectorTestConfig);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (hostNames != null) {
            Ec2RemoteTestUtils.destroyInstances(hostNames, ec2FailureDetectorTestConfig);
        }
    }

    @Before
    public void setUp() throws Exception {
        RemoteTestUtils.deploy(hostNames, ec2FailureDetectorTestConfig);
        RemoteTestUtils.startClusterAsync(hostNames, ec2FailureDetectorTestConfig, nodeIds);
        String url = "tcp://" + this.getRandomHostName() + ":6666";
        SocketStoreClientFactory scf = new SocketStoreClientFactory(new ClientConfig().setBootstrapUrls(new String[]{url}));
        this.failureDetector = scf.getFailureDetector();
        this.store = scf.getStoreClient("test");
    }

    @After
    public void tearDown() throws Exception {
        RemoteTestUtils.stopClusterQuiet(hostNames, ec2FailureDetectorTestConfig);
    }

    @Test
    public void testSingleNodeOffline() throws Exception {
        String offlineHostName = this.getRandomHostName();
        Node offlineNode = this.getNodeByHostName(offlineHostName, this.failureDetector);
        this.test(this.store);
        Assert.assertEquals((int)hostNamePairs.size(), (int)this.failureDetector.getAvailableNodeCount());
        Assert.assertTrue((boolean)this.failureDetector.isAvailable(offlineNode));
        RemoteTestUtils.stopClusterNode(offlineHostName, ec2FailureDetectorTestConfig);
        this.test(this.store);
        Assert.assertEquals((int)(hostNamePairs.size() - 1), (int)this.failureDetector.getAvailableNodeCount());
        Assert.assertFalse((boolean)this.failureDetector.isAvailable(offlineNode));
        RemoteTestUtils.startClusterNode(offlineHostName, ec2FailureDetectorTestConfig, offlineNode.getId());
        this.failureDetector.waitForAvailability(offlineNode);
        this.test(this.store);
        Assert.assertEquals((int)hostNamePairs.size(), (int)this.failureDetector.getAvailableNodeCount());
        Assert.assertTrue((boolean)this.failureDetector.isAvailable(offlineNode));
    }

    @Test
    public void testAllNodesOffline() throws Exception {
        this.test(this.store);
        Assert.assertEquals((int)hostNamePairs.size(), (int)this.failureDetector.getAvailableNodeCount());
        for (Node n : this.failureDetector.getConfig().getNodes()) {
            Assert.assertTrue((boolean)this.failureDetector.isAvailable(n));
        }
        RemoteTestUtils.stopClusterQuiet(hostNames, ec2FailureDetectorTestConfig);
        this.test(this.store);
        Assert.assertEquals((int)0, (int)this.failureDetector.getAvailableNodeCount());
        for (Node n : this.failureDetector.getConfig().getNodes()) {
            Assert.assertFalse((boolean)this.failureDetector.isAvailable(n));
        }
        RemoteTestUtils.startClusterAsync(hostNames, ec2FailureDetectorTestConfig, nodeIds);
        for (Node n : this.failureDetector.getConfig().getNodes()) {
            this.failureDetector.waitForAvailability(n);
        }
        this.test(this.store);
        Assert.assertEquals((int)hostNamePairs.size(), (int)this.failureDetector.getAvailableNodeCount());
        for (Node n : this.failureDetector.getConfig().getNodes()) {
            Assert.assertTrue((boolean)this.failureDetector.isAvailable(n));
        }
    }

    @Test
    public void testStress() throws Exception {
        final AtomicBoolean isRunning = new AtomicBoolean(true);
        ExecutorService threadPool = Executors.newFixedThreadPool(ec2FailureDetectorTestConfig.testThreads + 1);
        for (int i = 0; i < ec2FailureDetectorTestConfig.testThreads; ++i) {
            threadPool.submit(new Runnable(){

                public void run() {
                    while (isRunning.get()) {
                        Ec2FailureDetectorTest.this.test((StoreClient<String, String>)Ec2FailureDetectorTest.this.store, 100);
                    }
                }
            });
        }
        threadPool.submit(new Runnable(){

            public void run() {
                block3: {
                    try {
                        Random random = new Random();
                        while (isRunning.get()) {
                            String offlineHostName = Ec2FailureDetectorTest.this.getRandomHostName();
                            Node offlineNode = Ec2FailureDetectorTest.this.getNodeByHostName(offlineHostName, Ec2FailureDetectorTest.this.failureDetector);
                            RemoteTestUtils.stopClusterNode(offlineHostName, ec2FailureDetectorTestConfig);
                            Thread.sleep(random.nextInt(10000));
                            RemoteTestUtils.startClusterNode(offlineHostName, ec2FailureDetectorTestConfig, offlineNode.getId());
                            Thread.sleep(random.nextInt(10000));
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isEnabledFor((Priority)Level.ERROR)) break block3;
                        logger.error((Object)e);
                    }
                }
            }
        });
        Thread.sleep(ec2FailureDetectorTestConfig.testTime * 60 * 1000);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Shutting down");
        }
        isRunning.set(false);
        threadPool.shutdown();
        threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        Assert.assertEquals((int)hostNamePairs.size(), (int)this.failureDetector.getAvailableNodeCount());
    }

    private void test(StoreClient<String, String> store) {
        this.test(store, 1000);
    }

    private void test(StoreClient<String, String> store, int tests) {
        for (int i = 0; i < tests; ++i) {
            try {
                store.get((Object)("test_" + i));
                continue;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e);
            }
        }
    }

    private Node getNodeByHostName(String hostName, FailureDetector failureDetector) throws Exception {
        Integer offlineNodeId = nodeIds.get(hostName);
        for (Node n : failureDetector.getConfig().getNodes()) {
            if (!offlineNodeId.equals(n.getId())) continue;
            return n;
        }
        throw new Exception();
    }

    private String getRandomHostName() {
        Random random = new Random();
        return hostNames.get(random.nextInt(hostNames.size()));
    }

    static {
        logger = Logger.getLogger(Ec2FailureDetectorTest.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ec2FailureDetectorTestConfig
    extends Ec2RemoteTestConfig {
        private int testThreads;
        private int testTime;

        private Ec2FailureDetectorTestConfig() {
        }

        @Override
        protected void init(Properties properties) {
            super.init(properties);
            this.testThreads = this.getIntProperty(properties, "ec2TestThreads");
            this.testTime = this.getIntProperty(properties, "ec2TestTime");
        }

        @Override
        protected List<String> getRequiredPropertyNames() {
            List<String> requireds = super.getRequiredPropertyNames();
            requireds.addAll(Arrays.asList("ec2TestThreads", "ec2TestTime"));
            return requireds;
        }
    }
}

