/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.utils.ClusterNodeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterGenerator {
    private static final long SEED = 5276239082346L;

    public List<ClusterNodeDescriptor> createClusterNodeDescriptors(List<String> hostNames, int numPartitions) {
        int totalPartitions = hostNames.size() * numPartitions;
        ArrayList<Integer> allPartitionIds = new ArrayList<Integer>();
        for (int i = 0; i < totalPartitions; ++i) {
            allPartitionIds.add(i);
        }
        Random random = new Random(5276239082346L);
        Collections.shuffle(allPartitionIds, random);
        ArrayList<ClusterNodeDescriptor> list = new ArrayList<ClusterNodeDescriptor>();
        for (int i = 0; i < hostNames.size(); ++i) {
            String hostName = hostNames.get(i);
            List<Integer> partitions = allPartitionIds.subList(i * numPartitions, (i + 1) * numPartitions);
            Collections.sort(partitions);
            ClusterNodeDescriptor cnd = new ClusterNodeDescriptor();
            cnd.setHostName(hostName);
            cnd.setId(i);
            cnd.setPartitions(partitions);
            list.add(cnd);
        }
        return list;
    }

    public List<ClusterNodeDescriptor> createClusterNodeDescriptors(List<String> hostNames, Cluster cluster) {
        if (cluster.getNumberOfNodes() > hostNames.size()) {
            throw new IllegalStateException("cluster size exceeds the number of available instances");
        }
        ArrayList<ClusterNodeDescriptor> list = new ArrayList<ClusterNodeDescriptor>();
        for (int i = 0; i < cluster.getNumberOfNodes(); ++i) {
            Node node = cluster.getNodeById(i);
            String hostName = hostNames.get(i);
            List partitions = node.getPartitionIds();
            ClusterNodeDescriptor cnd = new ClusterNodeDescriptor();
            cnd.setHostName(hostName);
            cnd.setId(i);
            cnd.setSocketPort(node.getSocketPort());
            cnd.setHttpPort(node.getHttpPort());
            cnd.setAdminPort(node.getAdminPort());
            cnd.setPartitions(partitions);
            list.add(cnd);
        }
        return list;
    }

    public String createClusterDescriptor(String clusterName, List<String> hostNames, int numPartitions) {
        List<ClusterNodeDescriptor> clusterNodeDescriptors = this.createClusterNodeDescriptors(hostNames, numPartitions);
        return this.createClusterDescriptor(clusterName, clusterNodeDescriptors);
    }

    public String createClusterDescriptor(String clusterName, List<ClusterNodeDescriptor> clusterNodeDescriptors) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<cluster>");
        pw.println("\t<name>" + clusterName + "</name>");
        for (ClusterNodeDescriptor cnd : clusterNodeDescriptors) {
            String partitions = StringUtils.join(cnd.getPartitions(), (String)", ");
            pw.println("\t<server>");
            pw.println("\t\t<id>" + cnd.getId() + "</id>");
            pw.println("\t\t<host>" + cnd.getHostName() + "</host>");
            pw.println("\t\t<http-port>" + cnd.getHttpPort() + "</http-port>");
            pw.println("\t\t<socket-port>" + cnd.getSocketPort() + "</socket-port>");
            pw.println("\t\t<admin-port>" + cnd.getAdminPort() + "</admin-port>");
            pw.println("\t\t<partitions>" + partitions + "</partitions>");
            pw.println("\t</server>");
        }
        pw.println("</cluster>");
        return sw.toString();
    }
}

