/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.mr;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.store.StoreDefinition;
import voldemort.store.readonly.checksum.CheckSum;
import voldemort.store.readonly.mr.AbstractHadoopStoreBuilderMapper;
import voldemort.store.readonly.mr.HadoopStoreBuilderPartitioner;
import voldemort.store.readonly.mr.HadoopStoreBuilderReducer;
import voldemort.utils.Utils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopStoreBuilder {
    public static final long MIN_CHUNK_SIZE = 1L;
    public static final long MAX_CHUNK_SIZE = 0x79999999L;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private static final Logger logger = Logger.getLogger(HadoopStoreBuilder.class);
    private final Configuration config;
    private final Class<? extends AbstractHadoopStoreBuilderMapper<?, ?>> mapperClass;
    private final Class<? extends InputFormat> inputFormatClass;
    private final Cluster cluster;
    private final StoreDefinition storeDef;
    private final int replicationFactor;
    private final long chunkSizeBytes;
    private final Path inputPath;
    private final Path outputDir;
    private final Path tempDir;
    private CheckSum.CheckSumType checkSumType = CheckSum.CheckSumType.NONE;

    public HadoopStoreBuilder(Configuration conf, Class<? extends AbstractHadoopStoreBuilderMapper<?, ?>> mapperClass, Class<? extends InputFormat> inputFormatClass, Cluster cluster, StoreDefinition storeDef, int replicationFactor, long chunkSizeBytes, Path tempDir, Path outputDir, Path inputPath) {
        this.config = conf;
        this.mapperClass = (Class)Utils.notNull(mapperClass);
        this.inputFormatClass = (Class)Utils.notNull(inputFormatClass);
        this.inputPath = inputPath;
        this.cluster = (Cluster)Utils.notNull((Object)cluster);
        this.storeDef = (StoreDefinition)Utils.notNull((Object)storeDef);
        this.replicationFactor = replicationFactor;
        this.chunkSizeBytes = chunkSizeBytes;
        this.tempDir = tempDir;
        this.outputDir = (Path)Utils.notNull((Object)outputDir);
        if (chunkSizeBytes > 0x79999999L || chunkSizeBytes < 1L) {
            throw new VoldemortException("Invalid chunk size, chunk size must be in the range 1...2040109465");
        }
    }

    public HadoopStoreBuilder(Configuration conf, Class<? extends AbstractHadoopStoreBuilderMapper<?, ?>> mapperClass, Class<? extends InputFormat> inputFormatClass, Cluster cluster, StoreDefinition storeDef, int replicationFactor, long chunkSizeBytes, Path tempDir, Path outputDir, Path inputPath, CheckSum.CheckSumType checkSumType) {
        this(conf, mapperClass, inputFormatClass, cluster, storeDef, replicationFactor, chunkSizeBytes, tempDir, outputDir, inputPath);
        this.checkSumType = checkSumType;
    }

    public void build() {
        JobConf conf = new JobConf(this.config);
        conf.setInt("io.file.buffer.size", 65536);
        conf.set("cluster.xml", new ClusterMapper().writeCluster(this.cluster));
        conf.set("stores.xml", new StoreDefinitionsMapper().writeStoreList(Collections.singletonList(this.storeDef)));
        conf.setInt("store.output.replication.factor", this.replicationFactor);
        conf.setPartitionerClass(HadoopStoreBuilderPartitioner.class);
        conf.setMapperClass(this.mapperClass);
        conf.setMapOutputKeyClass(BytesWritable.class);
        conf.setMapOutputValueClass(BytesWritable.class);
        conf.setReducerClass(HadoopStoreBuilderReducer.class);
        conf.setInputFormat(this.inputFormatClass);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(BytesWritable.class);
        conf.setOutputValueClass(BytesWritable.class);
        conf.setJarByClass(this.getClass());
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.inputPath});
        conf.set("final.output.dir", this.outputDir.toString());
        conf.set("checksum.type", CheckSum.toString(this.checkSumType));
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.tempDir);
        try {
            FileSystem outputFs = this.outputDir.getFileSystem((Configuration)conf);
            if (outputFs.exists(this.outputDir)) {
                throw new IOException("Final output directory already exists.");
            }
            FileSystem tempFs = this.tempDir.getFileSystem((Configuration)conf);
            tempFs.delete(this.tempDir, true);
            long size = this.sizeOfPath(tempFs, this.inputPath);
            int numChunks = Math.max((int)((long)this.storeDef.getReplicationFactor() * size / (long)this.cluster.getNumberOfNodes() / this.chunkSizeBytes), 1);
            logger.info((Object)("Data size = " + size + ", replication factor = " + this.storeDef.getReplicationFactor() + ", numNodes = " + this.cluster.getNumberOfNodes() + ", chunk size = " + this.chunkSizeBytes + ",  num.chunks = " + numChunks));
            conf.setInt("num.chunks", numChunks);
            int numReduces = this.cluster.getNumberOfNodes() * numChunks;
            conf.setNumReduceTasks(numReduces);
            logger.info((Object)("Number of reduces: " + numReduces));
            logger.info((Object)"Building store...");
            JobClient.runJob((JobConf)conf);
            if (this.checkSumType != CheckSum.CheckSumType.NONE) {
                FileStatus[] nodes = outputFs.listStatus(this.outputDir);
                CheckSum checkSumGenerator = CheckSum.getInstance(this.checkSumType);
                if (checkSumGenerator == null) {
                    throw new VoldemortException("Could not generate checksum digests");
                }
                for (FileStatus node : nodes) {
                    FileStatus[] storeFiles;
                    if (!node.isDir() || (storeFiles = outputFs.listStatus(node.getPath(), new PathFilter(){

                        public boolean accept(Path arg0) {
                            return arg0.getName().endsWith("checksum") && !arg0.getName().startsWith(".");
                        }
                    })) == null) continue;
                    Arrays.sort(storeFiles, new IndexFileLastComparator());
                    for (FileStatus file : storeFiles) {
                        FSDataInputStream input = outputFs.open(file.getPath());
                        byte[] fileCheckSum = new byte[CheckSum.checkSumLength(this.checkSumType)];
                        input.read(fileCheckSum);
                        checkSumGenerator.update(fileCheckSum);
                        outputFs.delete(file.getPath(), true);
                    }
                    FSDataOutputStream checkSumStream = outputFs.create(new Path(node.getPath(), CheckSum.toString(this.checkSumType) + "checkSum.txt"));
                    checkSumStream.write(checkSumGenerator.getCheckSum());
                    checkSumStream.flush();
                    checkSumStream.close();
                }
            }
        }
        catch (Exception e) {
            throw new VoldemortException((Throwable)e);
        }
    }

    private long sizeOfPath(FileSystem fs, Path path) throws IOException {
        long size = 0L;
        FileStatus[] statuses = fs.listStatus(path);
        if (statuses != null) {
            for (FileStatus status : statuses) {
                if (status.isDir()) {
                    size += this.sizeOfPath(fs, status.getPath());
                    continue;
                }
                size += status.getLen();
            }
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IndexFileLastComparator
    implements Comparator<FileStatus> {
        IndexFileLastComparator() {
        }

        @Override
        public int compare(FileStatus fs1, FileStatus fs2) {
            if (fs1.isDir()) {
                return fs2.isDir() ? 0 : -1;
            }
            if (fs1.getPath().getName().endsWith(".index")) {
                return fs2.getPath().getName().endsWith(".index") ? 0 : 1;
            }
            return 0;
        }
    }
}

