/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.mr;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.hadoop.mapred.JobConf;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.store.StoreDefinition;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

public class AbstractStoreBuilderConfigurable {
    private int numChunks;
    private Cluster cluster;
    private StoreDefinition storeDef;

    public void configure(JobConf conf) {
        this.cluster = new ClusterMapper().readCluster((Reader)new StringReader(conf.get("cluster.xml")));
        List storeDefs = new StoreDefinitionsMapper().readStoreList((Reader)new StringReader(conf.get("stores.xml")));
        if (storeDefs.size() != 1) {
            throw new IllegalStateException("Expected to find only a single store, but found multiple!");
        }
        this.storeDef = (StoreDefinition)storeDefs.get(0);
        this.numChunks = conf.getInt("num.chunks", -1);
        if (this.numChunks < 1) {
            throw new VoldemortException("num.chunks not specified in the job conf.");
        }
    }

    public void close() throws IOException {
    }

    public Cluster getCluster() {
        this.checkNotNull(this.cluster);
        return this.cluster;
    }

    public StoreDefinition getStoreDef() {
        this.checkNotNull(this.storeDef);
        return this.storeDef;
    }

    public String getStoreName() {
        this.checkNotNull(this.storeDef);
        return this.storeDef.getName();
    }

    private final void checkNotNull(Object o) {
        if (o == null) {
            throw new VoldemortException("Not configured yet!");
        }
    }

    public int getNumChunks() {
        return this.numChunks;
    }
}

