/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.checksum;

import java.security.NoSuchAlgorithmException;
import voldemort.store.readonly.checksum.Adler32CheckSum;
import voldemort.store.readonly.checksum.CRC32CheckSum;
import voldemort.store.readonly.checksum.MD5CheckSum;
import voldemort.utils.ByteUtils;

public abstract class CheckSum {
    public abstract void update(byte[] var1, int var2, int var3);

    public void update(int number) {
        byte[] numberInBytes = new byte[4];
        ByteUtils.writeInt((byte[])numberInBytes, (int)number, (int)0);
        this.update(numberInBytes);
    }

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public abstract byte[] getCheckSum();

    public static CheckSum getInstance(CheckSumType type) {
        if (type == CheckSumType.ADLER32) {
            return new Adler32CheckSum();
        }
        if (type == CheckSumType.CRC32) {
            return new CRC32CheckSum();
        }
        if (type == CheckSumType.MD5) {
            try {
                return new MD5CheckSum();
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
        return null;
    }

    public static int checkSumLength(CheckSumType type) {
        if (type == CheckSumType.ADLER32) {
            return 8;
        }
        if (type == CheckSumType.CRC32) {
            return 8;
        }
        if (type == CheckSumType.MD5) {
            return 16;
        }
        return 0;
    }

    public static String toString(CheckSumType type) {
        if (type == CheckSumType.ADLER32) {
            return "adler32";
        }
        if (type == CheckSumType.CRC32) {
            return "crc32";
        }
        if (type == CheckSumType.MD5) {
            return "md5";
        }
        if (type == CheckSumType.NONE) {
            return "none";
        }
        return "none";
    }

    public static CheckSumType fromString(String input) {
        if (input.contains("adler32")) {
            return CheckSumType.ADLER32;
        }
        if (input.contains("crc32")) {
            return CheckSumType.CRC32;
        }
        if (input.contains("md5")) {
            return CheckSumType.MD5;
        }
        return CheckSumType.NONE;
    }

    public static CheckSum getInstance(String algorithm) {
        return CheckSum.getInstance(CheckSum.fromString(algorithm));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckSumType {
        NONE,
        ADLER32,
        MD5,
        CRC32;


        public static CheckSumType toType(String val) {
            return CheckSum.fromString(val);
        }
    }
}

