/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.mongodb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mongodb.driver.MongoDBException;
import org.mongodb.driver.MongoDBIOException;
import org.mongodb.driver.impl.DirectBufferTLS;
import org.mongodb.driver.ts.DB;
import org.mongodb.driver.ts.DBCollection;
import org.mongodb.driver.ts.DBCursor;
import org.mongodb.driver.ts.Doc;
import org.mongodb.driver.ts.IndexInfo;
import org.mongodb.driver.ts.Mongo;
import org.mongodb.driver.ts.MongoSelector;
import org.mongodb.driver.util.BSONObject;
import org.mongodb.driver.util.types.BSONBytes;
import voldemort.VoldemortException;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.StorageEngine;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Occured;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBStorageEngine
implements StorageEngine<ByteArray, byte[]> {
    private static final Logger logger = Logger.getLogger((String)MongoDBStorageEngine.class.getName());
    public static final String KEY = "k";
    public static final String CLOCK = "c";
    public static final String VALUE = "v";
    public static final String DB_NAME = "voldemort";
    protected Mongo mongoDb;
    protected DB db;
    protected DBCollection coll;
    protected final String collectionName;

    public MongoDBStorageEngine(String name) throws MongoDBException {
        logger.info((Object)"MongoDB Storage Engine : v0.1");
        this.collectionName = name;
        this.init();
    }

    protected final void init() throws MongoDBException {
        this.mongoDb = new Mongo("127.0.0.1", 27017);
        this.db = this.mongoDb.getDB(DB_NAME);
        this.coll = this.db.getCollection(this.collectionName);
        this.coll.createIndex(new IndexInfo("k_1", new String[]{KEY}));
    }

    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        try {
            return new MongoDBClosableIterator();
        }
        catch (MongoDBException e) {
            throw new VoldemortException((Throwable)e);
        }
    }

    public ClosableIterator<ByteArray> keys() {
        return StoreUtils.keys(this.entries());
    }

    public void truncate() {
        try {
            this.coll.clear();
        }
        catch (MongoDBException e) {
            throw new VoldemortException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Versioned<byte[]>> get(ByteArray key) throws VoldemortException {
        StoreUtils.assertValidKey((Object)key);
        DirectBufferTLS tls = this.getTLS();
        ArrayList<Versioned<byte[]>> list = new ArrayList<Versioned<byte[]>>();
        String strKey = new String(key.get());
        DBCursor cur = null;
        try {
            cur = this.coll.find(new MongoSelector(KEY, (Object)strKey));
            Iterator i$ = cur.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    this.closeCursor(cur);
                    return list;
                }
                Doc d = (Doc)i$.next();
                BSONObject bo = new BSONObject(tls.getReadBuffer());
                bo.serialize(d.getDoc(VALUE));
                Versioned val = new Versioned((Object)bo.toArray(), (Version)new VectorClock(d.getBytes(CLOCK)));
                list.add((Versioned<byte[]>)val);
            }
        }
        catch (MongoDBIOException mioe) {
            try {
                try {
                    this.init();
                    throw new VoldemortException((Throwable)mioe);
                }
                catch (MongoDBException ee) {
                    ee.printStackTrace();
                }
                throw new VoldemortException((Throwable)mioe);
                catch (MongoDBException e) {
                    throw new VoldemortException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(cur);
                throw throwable;
            }
        }
    }

    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        HashMap<ByteArray, List<Versioned<byte[]>>> map = new HashMap<ByteArray, List<Versioned<byte[]>>>();
        for (ByteArray b : keys) {
            List<Versioned<byte[]>> list = this.get(b);
            if (list.size() <= 0) continue;
            map.put(b, list);
        }
        return map;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(ByteArray key, Versioned<byte[]> value) throws VoldemortException {
        StoreUtils.assertValidKey((Object)key);
        this.getTLS();
        String strKey = new String(key.get());
        DBCursor cur = null;
        try {
            cur = this.coll.find((Map)new Doc(KEY, (Object)strKey));
            Iterator i$ = cur.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    Doc newData = new Doc(KEY, (Object)strKey);
                    newData.put(VALUE, (Object)new BSONBytes((byte[])value.getValue()));
                    newData.put(CLOCK, (Object)((VectorClock)value.getVersion()).toBytes());
                    this.coll.insert(newData);
                    this.closeCursor(cur);
                    return;
                }
                Doc d = (Doc)i$.next();
                VectorClock existingClock = new VectorClock(d.getBytes(CLOCK));
                Occured occured = value.getVersion().compare((Version)existingClock);
                if (occured == Occured.BEFORE) {
                    throw new ObsoleteVersionException("Key '" + strKey + " is obsolete.");
                }
                if (occured != Occured.AFTER) continue;
                this.coll.remove(new MongoSelector(d));
            }
        }
        catch (MongoDBIOException mioe) {
            try {
                try {
                    this.init();
                    throw new VoldemortException((Throwable)mioe);
                }
                catch (MongoDBException ee) {
                    ee.printStackTrace();
                }
                throw new VoldemortException((Throwable)mioe);
                catch (MongoDBException e) {
                    throw new VoldemortException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(cur);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey((Object)key);
        this.getTLS();
        String strKey = new String(key.get());
        boolean deleted = false;
        DBCursor cur = null;
        try {
            cur = this.coll.find((Map)new Doc(KEY, (Object)strKey));
            Iterator i$2222222 = cur.iterator();
            while (true) {
                if (!i$2222222.hasNext()) {
                    boolean i$2222222 = deleted;
                    this.closeCursor(cur);
                    return i$2222222;
                }
                Doc d = (Doc)i$2222222.next();
                VectorClock existingClock = new VectorClock(d.getBytes(CLOCK));
                Occured occured = version.compare((Version)existingClock);
                if (occured != Occured.BEFORE) continue;
                this.coll.remove(new MongoSelector(d));
                deleted = true;
            }
        }
        catch (MongoDBIOException mioe) {
            try {
                try {
                    this.init();
                    throw new VoldemortException((Throwable)mioe);
                }
                catch (MongoDBException ee) {
                    ee.printStackTrace();
                }
                throw new VoldemortException((Throwable)mioe);
                catch (MongoDBException e) {
                    throw new VoldemortException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(cur);
                throw throwable;
            }
        }
    }

    public String getName() {
        return this.coll.getName();
    }

    public void close() throws VoldemortException {
        try {
            if (this.db != null) {
                this.db.close();
            }
        }
        catch (Exception e) {
            throw new VoldemortException((Throwable)e);
        }
    }

    protected void clearStore() {
        try {
            this.coll.clear();
        }
        catch (MongoDBException e) {
            logger.error((Object)"Error while clearing store.", (Throwable)e);
        }
    }

    private void closeCursor(DBCursor cur) {
        if (cur == null) {
            return;
        }
        try {
            cur.close();
        }
        catch (MongoDBException e) {
            logger.error((Object)"Error while closing cursor.", (Throwable)e);
        }
    }

    private DirectBufferTLS getTLS() {
        DirectBufferTLS tls = DirectBufferTLS.getThreadLocal();
        if (tls == null) {
            tls = new DirectBufferTLS();
            tls.set();
        }
        return tls;
    }

    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    public List<Version> getVersions(ByteArray key) {
        return StoreUtils.getVersions(this.get(key));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MongoDBClosableIterator
    implements ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> {
        BSONObject bo = new BSONObject();
        protected DBCursor cursor;

        public MongoDBClosableIterator() throws MongoDBException {
            MongoDBStorageEngine.this.getTLS();
            this.cursor = MongoDBStorageEngine.this.coll.find();
        }

        public void close() {
            MongoDBStorageEngine.this.closeCursor(this.cursor);
            this.cursor = null;
        }

        public boolean hasNext() {
            return this.cursor.hasMoreElements();
        }

        public Pair<ByteArray, Versioned<byte[]>> next() {
            try {
                Doc d = this.cursor.getNextObject();
                this.bo.serialize(d.getDoc(MongoDBStorageEngine.VALUE));
                Versioned val = new Versioned((Object)this.bo.toArray(), (Version)new VectorClock(d.getBytes(MongoDBStorageEngine.CLOCK)));
                return new Pair((Object)new ByteArray(d.getString(MongoDBStorageEngine.KEY).getBytes()), (Object)val);
            }
            catch (MongoDBException e) {
                throw new VoldemortException((Throwable)e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

