/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.krati;

import java.io.File;
import org.apache.log4j.Logger;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.krati.KratiStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.Props;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KratiStorageConfiguration
implements StorageConfiguration {
    public static final String TYPE_NAME = "krati";
    private static Logger logger = Logger.getLogger(KratiStorageConfiguration.class);
    private String dataDirectory;
    private int segmentFileSizeMB;
    private int initLevel;
    private double hashLoadFactor;
    private final Object lock = new Object();

    public KratiStorageConfiguration(VoldemortConfig config) {
        Props props = config.getAllProps();
        this.dataDirectory = props.getString("krati.segment.datadirectory", "/tmp/kratiSeg");
        this.segmentFileSizeMB = props.getInt("krati.segment.filesize.mb", 256);
        this.hashLoadFactor = props.getDouble("krati.load.factor", 0.75);
        this.initLevel = props.getInt("krati.initlevel", 2);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageEngine<ByteArray, byte[]> getStore(String storeName) {
        Object object = this.lock;
        synchronized (object) {
            File storeDir = new File(this.dataDirectory, storeName);
            if (!storeDir.exists()) {
                logger.info((Object)("Creating Krati data directory '" + storeDir.getAbsolutePath() + "."));
                storeDir.mkdirs();
            }
            return new KratiStorageEngine(storeName, this.segmentFileSizeMB, this.hashLoadFactor, this.initLevel, storeDir);
        }
    }

    public String getType() {
        return TYPE_NAME;
    }
}

