/*
 * Decompiled with CFR 0.152.
 */
package voldemort.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.hadoop.VoldemortInputSplit;
import voldemort.utils.ByteArray;
import voldemort.utils.Pair;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortRecordReader
extends RecordReader<ByteArray, Versioned<byte[]>> {
    private AdminClient adminClient;
    private Iterator<Pair<ByteArray, Versioned<byte[]>>> iter = null;
    private Pair<ByteArray, Versioned<byte[]>> currentPair = null;

    public void close() throws IOException {
        this.adminClient.stop();
    }

    public ByteArray getCurrentKey() throws IOException, InterruptedException {
        return (ByteArray)this.currentPair.getFirst();
    }

    public Versioned<byte[]> getCurrentValue() throws IOException, InterruptedException {
        return (Versioned)this.currentPair.getSecond();
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        VoldemortInputSplit voldemortSplit = (VoldemortInputSplit)split;
        this.adminClient = new AdminClient("tcp://" + voldemortSplit.getHostName() + ":" + voldemortSplit.getAdminPort(), new AdminClientConfig());
        ArrayList partitionIds = new ArrayList();
        partitionIds.addAll(this.adminClient.getAdminClientCluster().getNodeById(voldemortSplit.getNodeId().intValue()).getPartitionIds());
        this.iter = this.adminClient.fetchEntries(voldemortSplit.getNodeId().intValue(), voldemortSplit.getStoreName(), partitionIds, null, true);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.iter.hasNext()) {
            return false;
        }
        this.currentPair = this.iter.next();
        return true;
    }
}

