package userkit.sdk.profile;

import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import userkit.sdk.Utils;

/**
 * Created by khangnt on 8/15/16.
 * Email: khang.neon.1997@gmail.com
 */
public class UserProfile{
    public static final String USER_PROFILE_PREFERENCES = "userkit_user_profile";
    public static final String PROFILE_ID = "profileId";
    public static final String PROPERTIES_JSON = "propertiesJson";
    private Context context;
    private String profileId;
    private HashMap<String, Object> properties;

    public UserProfile(Context context) {
        Log.e("Userprofile", "UserProfile: new User profile instance");
        this.context = context;
        SharedPreferences preferences = context.getSharedPreferences(USER_PROFILE_PREFERENCES, Context.MODE_PRIVATE);
        this.profileId = preferences.getString(PROFILE_ID, null);
        if (profileId == null) {
            initDefaultValue();
            saveUserProfile();
        } else {
            String propertiesJson = preferences.getString(PROPERTIES_JSON, null);
            Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
            properties = new Gson().fromJson(propertiesJson, type);
        }
    }

    private void initDefaultValue() {
        String android_id = Settings.Secure.getString(context.getContentResolver(),
                Settings.Secure.ANDROID_ID);
        this.profileId = Utils.md5("android_" + android_id + "_" + new Date().getTime());
        this.properties = new HashMap<>();
    }

    protected void saveUserProfile() {
        String propertiesJson = new Gson().toJson(properties);
        SharedPreferences preferences = context.getSharedPreferences(USER_PROFILE_PREFERENCES, Context.MODE_PRIVATE);
        preferences.edit()
                .putString(PROFILE_ID, profileId)
                .putString(PROPERTIES_JSON, propertiesJson)
                .apply();
    }

    public ProfileEditor edit() {
        return new ProfileEditor();
    }

    public String getProfileId() {
        return profileId;
    }

    protected HashMap<String, Object> getProperties() {
        return properties;
    }

    protected void setProperties(HashMap<String, Object> properties) {
        this.properties = properties;
    }

    protected void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getPropertyString(String name) {
        return String.class.cast(properties.get(name));
    }

    public Number getPropertyNumber(String name) {
        return Number.class.cast(properties.get(name));
    }

    public Boolean getPropertyBoolean(String name) {
        return Boolean.class.cast(properties.get(name));
    }

    public <T extends AbstractList<Object>> T getPropertyArray(String name) {
        //noinspection unchecked
        return ((T) properties.get(name));
    }
}
