package userkit.sdk.profile;

import android.content.Intent;

import java.util.HashMap;

import userkit.sdk.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public abstract class ProfileEditorBase {
    @ProfileEditType
    protected String editType;
    protected HashMap<String, Object> properties;

    protected ProfileEditorBase(@ProfileEditType String editType) {
        this.editType = editType;
        properties = new HashMap<>();
    }

    protected void putProperty(String name, Object value) {
        properties.put(name, value);
    }

    public String getEditType() {
        return editType;
    }

    public HashMap<String, Object> getProperties() {
        return properties;
    }

    public void commit() {
        updateProfileLocal();

    }

    protected abstract void updateProfileLocal();
}
