package userkit.sdk.profile;

import android.support.annotation.Nullable;

import java.util.AbstractList;

import userkit.sdk.annotations.ProfileEditType;
import userkit.sdk.exception.PropertyValueException;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfileDefaultEditor extends ProfileEditorBase {

    protected ProfileDefaultEditor(@ProfileEditType String editType) {
        super(editType);
    }

    @Override
    protected void updateProfileLocal() {

    }

    public ProfileDefaultEditor addProperty(String name, String value) {
        putProperty(name, value);
        return this;
    }

    public ProfileDefaultEditor addProperty(String name, Number value) {
        putProperty(name, value);
        return this;
    }

    public ProfileDefaultEditor addProperty(String name, Boolean value) {
        putProperty(name, value);
        return this;
    }

    public ProfileDefaultEditor addProperty(String name, @Nullable Object... value)  {
        if (value != null)
            for (Object element : value)
                if (element != null
                        && !(element instanceof String)
                        && !(element instanceof Boolean)
                        && !(element instanceof Number))
                    throw new PropertyValueException(element.getClass());
        putProperty(name, value);
        return this;
    }

    public ProfileDefaultEditor addProperty(String name, @Nullable AbstractList<Object> value)  {
        if (value != null)
            for (Object element : value)
                if (element != null
                        && !(element instanceof String)
                        && !(element instanceof Boolean)
                        && !(element instanceof Number))
                    throw new PropertyValueException(element.getClass());
        putProperty(name, value);
        return this;
    }

}
