package userkit.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;

import userkit.sdk.profile.UserProfile;

/**
 * Created by khangnt on 8/15/16.
 * Email: khang.neon.1997@gmail.com
 */
public class UserKit {
    public static final String USER_KIT_API_TOKEN = "USER_KIT_API_TOKEN";
    private Context context;
    private UserProfile userProfile;
    private String apiToken;

    private UserKit(Context context) {
        this.context = context.getApplicationContext();
        this.userProfile = new UserProfile(this.context);
    }

    private static UserKit singleInstance;

    public synchronized static void init(Context context) {
        init(context, null);
    }

    public synchronized static void init(Context context, String apiToken) {
        if (singleInstance == null)
            singleInstance = new UserKit(context);
        if (apiToken != null)
            singleInstance.setApiToken(apiToken);
        else { // Find api token from manifest meta data
            ApplicationInfo ai = null;
            try {
                ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                apiToken = bundle.getString(USER_KIT_API_TOKEN);
                singleInstance.setApiToken(apiToken);
            } catch (PackageManager.NameNotFoundException ignore) {
                Log.w("UserKit", "Warning: You haven't set API Token");
            }
        }
    }


    public static UserKit getInstance() {
        if (singleInstance == null)
            throw new IllegalStateException("Call UserKit.init(Context) first or use method UserKit.getInstance(Context)!");
        return singleInstance;
    }

    public static UserKit getInstance(Context context) {
        if (singleInstance == null)
            init(context);
        return singleInstance;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getApiToken() {
        return apiToken;
    }

    public Context getContext() {
        return context;
    }

    public UserProfile getUserProfile() {
        return userProfile;
    }
}
