package userkit.sdk.profile;

import org.json.JSONException;
import org.json.JSONObject;

import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import userkit.sdk.Logging;
import userkit.sdk.Utils;
import userkit.sdk.api.ErrorResponse;
import userkit.sdk.api.ServiceGenerator;
import userkit.sdk.api.UserKitService;
import userkit.sdk.callback.DefaultCallback;
import userkit.sdk.data.ProfileUpdateData;
import userkit.sdk.exception.ServerResponseErrorException;
import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfilePropertyEditor {
    @ProfileEditType
    protected String editType;

    ProfileUpdateData profileUpdateData;

    protected ProfilePropertyEditor(JSONObject properties, String profileId, @ProfileEditType String editType) {
        this.editType = editType;
        try {
            this.profileUpdateData = new ProfileUpdateData(profileId, properties);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @ProfileEditType
    public String getEditType() {
        return editType;
    }

    public JSONObject getProperties() {
        return profileUpdateData.getProperties();
    }

    public void commit() {
        commit(null);
    }

    public void commit(final DefaultCallback callback) {
        UserKitService userKitService = ServiceGenerator.buildUserKitService();
        Call<Void> call = getEndPointToCall(userKitService, Utils.buildRequestBody(profileUpdateData));
        call.enqueue(new Callback<Void>() {
            @Override
            public void onResponse(Call<Void> call, Response<Void> response) {
                if (callback == null)
                    return;
                if (response.isSuccessful()) {
                    callback.onSuccess();
                    Logging.d("ProfilePropertyEditor.onResponse", "Commit success");
                } else {
                    ErrorResponse errorResponse = new ErrorResponse(response);
                    ServerResponseErrorException exception = new ServerResponseErrorException(errorResponse);
                    callback.onError(exception);
                    Logging.e("ProfilePropertyEditor.onResponse", "Commit error", exception);
                }
            }

            @Override
            public void onFailure(Call<Void> call, Throwable t) {
                if (callback != null)
                    callback.onError(t);
                Logging.e("ProfilePropertyEditor.onResponse", "Commit error", t);
            }
        });
    }

    protected Call<Void> getEndPointToCall(UserKitService userKitService, RequestBody body) {
        if (getEditType().equals(ProfileEditType.SET))
            return userKitService.setProfile(body);
        return userKitService.profileUpdate(getEditType(), body);
    }
}
