package userkit.sdk.profile;

import org.json.JSONObject;

import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfileEditor {
    String profileId;

    public ProfileEditor(String profileId) {
        this.profileId = profileId;
    }

    public ProfilePropertyEditor set(JSONObject properties) {
        return new ProfilePropertyEditor(properties, profileId, ProfileEditType.SET);
    }

    public ProfilePropertyEditor setOnce(JSONObject properties) {
        return new ProfilePropertyEditor(properties, profileId, ProfileEditType.SET_IF_NOT_EXIST);
    }

    public ProfilePropertyEditor append(JSONObject properties) {
        return new ProfilePropertyEditor(properties, profileId, ProfileEditType.APPEND);
    }

    public ProfilePropertyEditor union(JSONObject properties) {
        return new ProfilePropertyEditor(properties, profileId, ProfileEditType.UNION);
    }

    public ProfilePropertyEditor increment(JSONObject properties) {
        return new ProfilePropertyEditor(properties, profileId, ProfileEditType.INCREMENT);
    }
}
