package userkit.sdk.data;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * Created by khangnt on 8/15/16.
 * Email: khang.neon.1997@gmail.com
 */
public class EventsData extends JSONObject {

    public static final String PROFILE_ID = "profile_id";
    public static final String EVENTS = "events";

    public EventsData(String profile_id, List<Event> events) throws JSONException {
        put(PROFILE_ID, profile_id);
        JSONArray jsonArray = new JSONArray();
        for (Event event : events) {
            jsonArray.put(event);
        }
        put(EVENTS, jsonArray);
    }
}
