package userkit.sdk.data;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONException;
import org.json.JSONObject;


/**
 * Created by khangnt on 8/12/16.
 * Email: khang.neon.1997@gmail.com
 */
public class Event extends JSONObject implements Parcelable {

    public static final String PROPERTIES = "properties";
    public static final String NAME = "name";

    public Event(String eventName, JSONObject properties) throws JSONException {
        put(NAME, eventName);
        put(PROPERTIES, properties);
    }

    public String getName() {
        try {
            return getString(NAME);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getProperties() {
        try {
            return getJSONObject(PROPERTIES);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected Event(Parcel in) throws JSONException {
        super(in.readString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(toString());
    }

    @SuppressWarnings("unused")
    public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>() {
        @Override
        public Event createFromParcel(Parcel in) {
            try {
                return new Event(in);
            } catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Event[] newArray(int size) {
            return new Event[size];
        }
    };

}
