package userkit.sdk.api;


import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import userkit.sdk.data.ProfileIdAliasData;
import userkit.sdk.data.TokenUpdateData;

/**
 * Created by khangnt on 8/12/16.
 * Email: khang.neon.1997@gmail.com
 */
public interface UserKitService {
    @POST("events/bulk")
    Call<Void> postEvents(@Body RequestBody body);

    @POST("profile")
    Call<Void> setProfile(@Body RequestBody body);

    @PUT
    Call<Void> profileUpdate(@Url String endPointUrl, @Body RequestBody body);

    @POST("alias")
    Call<Void> mapProfileId(@Body ProfileIdAliasData body);

    @POST("profile/token")
    Call<Void> updateGCMToken(@Body TokenUpdateData body);

    @GET("profile/properties")
    Call<String> getProperties(@Query("profile_id") String profileId, @Query("keys") String keys);

    @POST("profile/array/search")
    Call<String> searchInsideArray(@Body RequestBody body);

    @POST("profile/array/search")
    Call<Void> removeElementsInsideArray(@Body RequestBody body);

}
