package userkit.sdk.api;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import userkit.sdk.Constants;
import userkit.sdk.UserKit;

/**
 * Created by khangnt on 8/24/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ServiceGenerator {
    private static UserKitService sUserKitService;

    public static UserKitService buildUserKitService() {
        if (sUserKitService == null)
            sUserKitService = retrofit(Constants.USER_KIT_CLIENT)
                    .create(UserKitService.class);
        return sUserKitService;
    }

    private static Retrofit retrofit(String baseUrl) {
        return new Retrofit.Builder()
                .baseUrl(baseUrl)
                .client(new OkHttpClient.Builder().addInterceptor(new ApiTokenInterceptor()).build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
                .build();
    }

    private static class ApiTokenInterceptor implements Interceptor {

        @Override
        public Response intercept(Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithHeaders = originalRequest.newBuilder()
                    .header("Content-Type", "application/json")
                    .header("X-USERKIT-TOKEN", UserKit.getInstance().getApiToken())
                    .build();
            return chain.proceed(requestWithHeaders);
        }
    }
}
