package userkit.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import userkit.sdk.api.ErrorResponse;
import userkit.sdk.api.ServiceGenerator;
import userkit.sdk.api.UserKitService;
import userkit.sdk.callback.DefaultCallback;
import userkit.sdk.data.TokenUpdateData;
import userkit.sdk.exception.ServerResponseErrorException;
import userkit.sdk.exception.UserProfileNullException;
import userkit.sdk.profile.UserProfile;

/**
 * Created by khangnt on 8/15/16.
 * Email: khang.neon.1997@gmail.com
 */
public class UserKit {
    private static final String USER_KIT_API_TOKEN = "USER_KIT_API_TOKEN";
    public static final String TAG = "UserKit";
    private Context context;
    private String apiToken;

    private UserKit(Context context) {
        this.context = context.getApplicationContext();
    }

    @SuppressLint("StaticFieldLeak")
    private static UserKit singleInstance;

    public synchronized static void init(Context context) {
        init(context, null);
    }

    public synchronized static void init(Context context, String apiToken) {
        if (singleInstance == null)
            singleInstance = new UserKit(context);
        if (apiToken != null)
            singleInstance.setApiToken(apiToken);
        else { // Find api token from manifest meta data
            ApplicationInfo ai = null;
            try {
                ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                apiToken = bundle.getString(USER_KIT_API_TOKEN);
                singleInstance.setApiToken(apiToken);
            } catch (PackageManager.NameNotFoundException ignore) {
                Logging.w("UserKit.init", "You haven't set API Token");
            }
        }
    }


    public static UserKit getInstance() {
        if (singleInstance == null)
            throw new IllegalStateException("Call UserKit.init() first!");
        return singleInstance;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getApiToken() {
        return apiToken;
    }

    public Context getContext() {
        return context;
    }

    public void postGCMToken(String token, final DefaultCallback callback) {
        UserKitService userKitService = ServiceGenerator.buildUserKitService();
        UserProfile userProfile = UserProfile.getCurrentProfile();
        if (userProfile == null)
            throw new UserProfileNullException();
        userKitService.updateGCMToken(new TokenUpdateData(userProfile.getIdentifiedId(), token))
                .enqueue(new Callback<Void>() {
                    @Override
                    public void onResponse(Call<Void> call, Response<Void> response) {
                        if (response.isSuccessful())
                            callback.onSuccess();
                        else
                            callback.onError(new ServerResponseErrorException(new ErrorResponse(response)));
                    }

                    @Override
                    public void onFailure(Call<Void> call, Throwable t) {
                        callback.onError(t);
                    }
                });
    }
}
