package userkit.sdk.profile;

import android.support.annotation.NonNull;

import retrofit2.Call;
import userkit.sdk.api.UserKitService;
import userkit.sdk.callback.DefaultCallback;
import userkit.sdk.data.ProfileUpdateData;
import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/26/16.
 * Email: khang.neon.1997@gmail.com
 */
public class SetProfileProperty extends ProfilePropertyEditorDefault {
    public SetProfileProperty(String profileId) {
        super(profileId, ProfileEditType.SET);
    }

    @Override
    public ProfilePropertyEditorDefault putProperty(String name, Object value) {
        return super.putProperty(name, value);
    }

    @Override
    public ProfilePropertyEditorDefault putProperty(String name, @NonNull Object... value) {
        return super.putProperty(name, value);
    }

    @Override
    public void commit() {
        super.commit();
    }

    @Override
    public void commit(DefaultCallback callback) {
        super.commit(callback);
    }

    @Override
    protected Call<Void> getEndPointToCall(UserKitService userKitService, ProfileUpdateData data) {
        return userKitService.setProfile(data);
    }
}
