package userkit.sdk.profile;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

import userkit.sdk.callback.DefaultCallback;
import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/25/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfilePropertyUnion extends ProfilePropertyEditorDefault {
    public ProfilePropertyUnion(String profileId) {
        super(profileId, ProfileEditType.UNION);
    }

    @Override
    public ProfilePropertyUnion putProperty(String name, Object value) {
        unionIfExisting(name, value);
        return this;
    }

    @Override
    public ProfilePropertyUnion putProperty(String name, @NonNull Object... value) {
        unionIfExisting(name, Arrays.asList(value));
        return this;
    }

    private void unionIfExisting(String name, Object value) {
        if (properties.get(name) != null) {
            if (properties.get(name) instanceof AbstractList)
                super.putProperty(name, properties.getPropertyArray(name).add(value));
            else
                super.putProperty(name, properties.get(name), value);
        } else
            super.putProperty(name, value);
    }

    private void unionIfExisting(String name, List<Object> value) {
        if (properties.get(name) != null) {
            if (properties.get(name) instanceof AbstractList)
                super.putProperty(name, properties.getPropertyArray(name).addAll(value));
            else
                super.putProperty(name, value.add(properties.get(name)));
        } else
            super.putProperty(name, value);
    }

    @Override
    public void commit() {
        super.commit();
    }

    @Override
    public void commit(DefaultCallback callback) {
        super.commit(callback);
    }
}
