package userkit.sdk.profile;

import android.annotation.SuppressLint;

import userkit.sdk.callback.DefaultCallback;
import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfilePropertyIncrement extends ProfilePropertyEditorBase {
    public ProfilePropertyIncrement(String profileId) {
        super(profileId, ProfileEditType.INCREMENT);
    }

    public ProfilePropertyIncrement putProperty(String propertyName, int offset) {
        if (properties.get(propertyName) != null) {
            int currentValue = properties.getPropertyNumber(propertyName).intValue();
            offset += currentValue;
        }

        properties.putProperty(propertyName, offset);
        return this;
    }

    public ProfilePropertyIncrement putProperty(String propertyName, long offset) {
        if (properties.get(propertyName) != null) {
            int currentValue = properties.getPropertyNumber(propertyName).intValue();
            offset += currentValue;
        }

        properties.putProperty(propertyName, offset);
        return this;
    }

    public ProfilePropertyIncrement putProperty(String propertyName, float offset) {
        if (properties.get(propertyName) != null) {
            int currentValue = properties.getPropertyNumber(propertyName).intValue();
            offset += currentValue;
        }

        properties.putProperty(propertyName, offset);
        return this;
    }

    public ProfilePropertyIncrement putProperty(String propertyName, double offset) {
        if (properties.get(propertyName) != null) {
            int currentValue = properties.getPropertyNumber(propertyName).intValue();
            offset += currentValue;
        }

        properties.putProperty(propertyName, offset);
        return this;
    }

    @Override
    public void commit() {
        super.commit();
    }

    @Override
    public void commit(DefaultCallback callback) {
        super.commit(callback);
    }
}
