package userkit.sdk.profile;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.AbstractList;

import userkit.sdk.callback.DefaultCallback;
import userkit.sdk.exception.PropertyValueException;
import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfilePropertyEditorDefault extends ProfilePropertyEditorBase {

    public ProfilePropertyEditorDefault(String profileId, @ProfileEditType String editType) {
        super(profileId, editType);
    }

    public ProfilePropertyEditorDefault putProperty(String name, Object value) {
        properties.putProperty(name, value);
        return this;
    }

    public ProfilePropertyEditorDefault putProperty(String name, @NonNull Object... value) {
        properties.putProperty(name, value);
        return this;
    }

    @Override
    public void commit() {
        super.commit();
    }

    @Override
    public void commit(DefaultCallback callback) {
        super.commit(callback);
    }
}
