package userkit.sdk.profile;

import android.os.Parcel;
import android.os.Parcelable;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import userkit.sdk.Logging;
import userkit.sdk.Properties;
import userkit.sdk.api.ErrorResponse;
import userkit.sdk.api.ServiceGenerator;
import userkit.sdk.api.UserKitService;
import userkit.sdk.callback.DefaultCallback;
import userkit.sdk.data.ProfileUpdateData;
import userkit.sdk.exception.ServerResponseErrorException;
import userkit.sdk.exception.UserProfileNullException;
import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfilePropertyEditorBase {
    @ProfileEditType
    protected String editType;
    protected Properties properties;
    protected String profileId;

    protected ProfilePropertyEditorBase(String profileId, @ProfileEditType String editType) {
        this.profileId = profileId;
        this.editType = editType;
        this.properties = new Properties();
    }

    @ProfileEditType
    public String getEditType() {
        return editType;
    }

    public Properties getProperties() {
        return properties;
    }

    public void commit() {
        commit(null);
    }

    public void commit(final DefaultCallback callback) {
        UserKitService userKitService = ServiceGenerator.buildUserKitService();
        Call<Void> call = getEndPointToCall(userKitService,
                new ProfileUpdateData(profileId, getProperties()));
        call.enqueue(new Callback<Void>() {
            @Override
            public void onResponse(Call<Void> call, Response<Void> response) {
                if (callback == null)
                    return;
                if (response.isSuccessful()) {
                    callback.onSuccess();
                    Logging.d("ProfilePropertyEditorBase.onResponse", "Commit success");
                } else {
                    ErrorResponse errorResponse = new ErrorResponse(response);
                    ServerResponseErrorException exception = new ServerResponseErrorException(errorResponse);
                    callback.onError(exception);
                    Logging.e("ProfilePropertyEditorBase.onResponse", "Commit error", exception);
                }
            }

            @Override
            public void onFailure(Call<Void> call, Throwable t) {
                if (callback != null)
                    callback.onError(t);
                Logging.e("ProfilePropertyEditorBase.onResponse", "Commit error", t);
            }
        });
    }

    protected Call<Void> getEndPointToCall(UserKitService userKitService, ProfileUpdateData data) {
        return userKitService.profileUpdate(getEditType(), data);
    }
}
