package userkit.sdk.profile;

import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfileEditor {
    String profileId;

    public ProfileEditor(String profileId) {
        this.profileId = profileId;
    }

    public ProfilePropertyEditorDefault set() {
        return new SetProfileProperty(profileId);
    }

    public ProfilePropertyEditorDefault setOnce() {
        return new ProfilePropertyEditorDefault(profileId, ProfileEditType.SET_IF_NOT_EXIST);
    }

    public ProfilePropertyEditorDefault append() {
        return new ProfilePropertyEditorDefault(profileId, ProfileEditType.APPEND);
    }

    public ProfilePropertyEditorDefault union() {
        return new ProfilePropertyUnion(profileId);
    }

    public ProfilePropertyIncrement increment() {
        return new ProfilePropertyIncrement(profileId);
    }
}
