package userkit.sdk.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;

import userkit.sdk.Properties;

/**
 * Created by khangnt on 8/12/16.
 * Email: khang.neon.1997@gmail.com
 */
public class Event implements Parcelable {
    protected String name;
    protected Properties properties;

    public Event(String eventName) {
        this.name = eventName;
        this.properties = new Properties();
    }

    public String getName() {
        return name;
    }

    public Properties getProperties() {
        return properties;
    }

    public Event putProperty(String name, Object value) {
        this.properties.putProperty(name, value);
        return this;
    }

    public Event putProperty(String name, @NonNull Object... value) {
        this.properties.putProperty(name, value);
        return this;
    }

    protected Event(Parcel in) {
        name = in.readString();
        properties = in.readParcelable(Properties.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(name);
        dest.writeParcelable(properties, flags);
    }

    @SuppressWarnings("unused")
    public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>() {
        @Override
        public Event createFromParcel(Parcel in) {
            return new Event(in);
        }

        @Override
        public Event[] newArray(int size) {
            return new Event[size];
        }
    };

}
