package userkit.sdk.api;


import java.util.List;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import userkit.sdk.Properties;
import userkit.sdk.data.ArraySearchData;
import userkit.sdk.data.EventsData;
import userkit.sdk.data.ProfileIdAliasData;
import userkit.sdk.data.ProfileUpdateData;
import userkit.sdk.data.TokenUpdateData;

/**
 * Created by khangnt on 8/12/16.
 * Email: khang.neon.1997@gmail.com
 */
public interface UserKitService {
    @POST("events/bulk")
    Call<Void> postEvents(@Body EventsData body);

    @POST("profile")
    Call<Void> setProfile(@Body ProfileUpdateData body);

    @PUT
    Call<Void> profileUpdate(@Url String endPointUrl, @Body ProfileUpdateData body);

    @POST("alias")
    Call<Void> mapProfileId(@Body ProfileIdAliasData body);

    @POST("profile/token")
    Call<Void> updateGCMToken(@Body TokenUpdateData body);

    @GET("profile/properties")
    Call<Properties> getProperties(@Query("profile_id") String profileId, @Query("keys") String keys);

    @POST("profile/array/search")
    Call<List<Object>> searchInsideArray(@Body ArraySearchData body);

    @POST("profile/array/search")
    Call<Void> removeElementsInsideArray(@Body ArraySearchData body);

}
