package userkit.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * Created by khangnt on 8/23/16.
 * Email: khang.neon.1997@gmail.com
 */
public class Properties extends HashMap<String, Object> implements Parcelable {
    public Properties() {
    }

    public Properties(HashMap<String, Object> data) {
        super(data);
    }

    protected Properties(Parcel in) {
        String dataJson = in.readString();
        HashMap<String, Object> data = new Gson().fromJson(dataJson, new TypeToken<HashMap<String, Object>>() {
        }.getType());
        putAll(data);
    }

    public Properties putProperty(String name, Object value) {
        put(name, value);
        return this;
    }

    public Properties putProperty(String name, @NonNull Object... value) {
        put(name, Arrays.asList(value));
        return this;
    }

    public <T> T getPropertyObject(String name, Class<T> clazz) {
        Object obj = get(name);
        return obj == null ? null : clazz.cast(obj);
    }

    public String getPropertyString(String name) {
        return ((String) get(name));
    }

    public Number getPropertyNumber(String name) {
        return ((Number) get(name));
    }

    public Boolean getPropertyBoolean(String name) {
        return ((Boolean) get(name));
    }

    public List<Object> getPropertyArray(String name) {
        //noinspection unchecked
        return ((List<Object>) get(name));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        String dataJson = new Gson().toJson(this);
        parcel.writeString(dataJson);
    }

    public static final Creator<Properties> CREATOR = new Creator<Properties>() {
        @Override
        public Properties createFromParcel(Parcel in) {
            return new Properties(in);
        }

        @Override
        public Properties[] newArray(int size) {
            return new Properties[size];
        }
    };

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
