package userkit.sdk;

import android.util.Log;

/**
 * Created by khangnt on 8/25/16.
 * Email: khang.neon.1997@gmail.com
 */
public class Logging {
    private static final String TAG = "UserKit";

    private static Boolean sShowLog = BuildConfig.DEBUG;

    public static void m(String method) {
        Log.d(TAG, method);
    }

    public static void w(String method, Object message) {
        if (sShowLog)
            Log.w(TAG, method + " : WARNING : " + message);
    }

    public static void d(String method, Object message) {
        if (sShowLog)
            Log.d(TAG, method + " : DEBUG : " + message);
    }

    public static void e(String method, Object message, Throwable causes) {
        if (sShowLog)
            Log.e(TAG, method + " : ERROR : " + message, causes);
    }

    public static void e(String method, Object message) {
        if (sShowLog)
            Log.e(TAG, method + " : ERROR : " + message);
    }

    public static void enable() {
        sShowLog = true;
    }

    public static void disable() {
        sShowLog = false;
    }
}
