package userkit.sdk.profile;

import android.annotation.SuppressLint;
import android.support.annotation.Nullable;

import java.util.AbstractList;

import userkit.sdk.exception.PropertyValueException;
import userkit.sdk.profile.annotations.ProfileEditType;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
@SuppressLint("ParcelCreator")
public class ProfilePropertyEditorDefault extends ProfilePropertyEditorBase {

    public ProfilePropertyEditorDefault(@ProfileEditType String editType) {
        super(editType);
    }

    public ProfilePropertyEditorDefault addProperty(String name, String value) {
        putProperty(name, value);
        return this;
    }

    public ProfilePropertyEditorDefault addProperty(String name, Number value) {
        putProperty(name, value);
        return this;
    }

    public ProfilePropertyEditorDefault addProperty(String name, Boolean value) {
        putProperty(name, value);
        return this;
    }

    public ProfilePropertyEditorDefault addProperty(String name, @Nullable Object... value) {
        if (value != null)
            for (Object element : value)
                if (element != null
                        && !(element instanceof String)
                        && !(element instanceof Boolean)
                        && !(element instanceof Number))
                    throw new PropertyValueException(element.getClass());
        putProperty(name, value);
        return this;
    }

    public ProfilePropertyEditorDefault addProperty(String name, @Nullable AbstractList<Object> value) {
        if (value != null)
            for (Object element : value)
                if (element != null
                        && !(element instanceof String)
                        && !(element instanceof Boolean)
                        && !(element instanceof Number))
                    throw new PropertyValueException(element.getClass());
        putProperty(name, value);
        return this;
    }

}
