package userkit.sdk.profile;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.Gson;

import java.util.Properties;

import userkit.sdk.UserKit;
import userkit.sdk.profile.annotations.ProfileEditType;
import userkit.sdk.service.SenderService;

/**
 * Created by khangnt on 8/16/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ProfilePropertyEditorBase implements Parcelable {
    @ProfileEditType
    protected String editType;
    protected Properties properties;

    protected ProfilePropertyEditorBase(@ProfileEditType String editType) {
        this.editType = editType;
        properties = new Properties();
    }

    protected ProfilePropertyEditorBase(Parcel in) {
        //noinspection WrongConstant
        editType = in.readString();
        String mapAsJSON = in.readString();
        properties = new Gson().fromJson(mapAsJSON, Properties.class);
    }

    protected void putProperty(String name, Object value) {
        properties.put(name, value);
    }

    @ProfileEditType
    public String getEditType() {
        return editType;
    }

    public Properties getProperties() {
        return properties;
    }

    public void commit() {
        Context context = UserKit.getInstance().getContext();
        Intent intent = new Intent(context, SenderService.class);
        intent.setAction(SenderService.ACTION_PROFILE_PROPERTY_EDITED);
        intent.putExtra(SenderService.PROFILE_PROPERTY_EDITOR_DATA, this);
        context.startService(intent);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(editType);
        // serialize HashMap<String, Object> to json by Gson
        String mapAsJSON = new Gson().toJson(properties);
        dest.writeString(mapAsJSON);
    }

    @SuppressWarnings("unused")
    public static final Parcelable.Creator<ProfilePropertyEditorBase> CREATOR = new Parcelable.Creator<ProfilePropertyEditorBase>() {
        @Override
        public ProfilePropertyEditorBase createFromParcel(Parcel in) {
            return new ProfilePropertyEditorBase(in);
        }

        @Override
        public ProfilePropertyEditorBase[] newArray(int size) {
            return new ProfilePropertyEditorBase[size];
        }
    };
}
