package userkit.sdk.livechat;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;

import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

import userkit.sdk.R;
import userkit.sdk.exception.UserProfileNullException;
import userkit.sdk.livechat.models.MessageModel;
import userkit.sdk.profile.UserProfile;

/**
 * Created by khangnt on 8/19/16.
 * Email: khang.neon.1997@gmail.com
 */
public class LiveChatActivity extends AppCompatActivity implements View.OnClickListener {
    public static final String TAG = "LiveChatActivity";
    public static final String CHAT_NODE = "live_chat";

    public static Intent createIntent(Context context, @NonNull String firebasePath) {
        Intent intent = new Intent(context, LiveChatActivity.class);
        intent.putExtra(CHAT_NODE, firebasePath);
        return intent;
    }


    ListView listView;
    EditText editTextMessage;
    Button buttonSend;
    private DatabaseReference chatNodeRef;
    private FireBaseLiveChatAdapter fireBaseLiveChatAdapter;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.live_chat_layout);
        listView = (ListView) findViewById(R.id.chat_contents);
        editTextMessage = (EditText) findViewById(R.id.ed_message);
        buttonSend = (Button) findViewById(R.id.btn_send);
        buttonSend.setOnClickListener(this);

        String firebaseChatNode = getIntent().getStringExtra(CHAT_NODE);
        if (TextUtils.isEmpty(firebaseChatNode))
            throw new NullPointerException("Firebase path must not be empty. See LiveChatActivity.createIntent(Context, String)");
        UserProfile userProfile = UserProfile.getCurrentProfile();
        if (userProfile == null)
            throw new UserProfileNullException();
        firebaseChatNode += "/messages/" + userProfile.getIdentifiedId();

        FirebaseDatabase firebaseDatabase = FirebaseDatabase.getInstance();
        chatNodeRef = firebaseDatabase.getReferenceFromUrl(firebaseChatNode);
        fireBaseLiveChatAdapter = new FireBaseLiveChatAdapter(chatNodeRef, this);

        listView.setAdapter(fireBaseLiveChatAdapter);
    }

    @Override
    public void onClick(View view) {
        String message = editTextMessage.getText().toString();
        if (!TextUtils.isEmpty(message)) {
            MessageModel messageModel = new MessageModel(message, false);
            chatNodeRef.push().setValue(messageModel);
            editTextMessage.setText("");
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        fireBaseLiveChatAdapter.cleanup();
    }
}
