package userkit.sdk.livechat;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.google.firebase.database.DatabaseReference;

import userkit.sdk.R;
import userkit.sdk.livechat.models.MessageModel;

/**
 * Created by khangnt on 8/19/16.
 * Email: khang.neon.1997@gmail.com
 */
public class FireBaseLiveChatAdapter extends FirebaseListAdapter<MessageModel> {
    public static final String TAG = "FireBaseLiveChatAdapter";

    public FireBaseLiveChatAdapter(DatabaseReference mRef, Context context) {
        super(mRef, MessageModel.class, context);
    }

    @Override
    protected int getItemViewType(int position, MessageModel model) {
        return model.isAdmin() ? 0 : 1;
    }

    @Override
    protected View populateView(LayoutInflater inflater, View v, ViewGroup parent, MessageModel model) {
        if (v == null) {
            v = inflater.inflate(model.isAdmin() ? R.layout.admin_message : R.layout.user_message, parent, false);
        }
        TextView message = (TextView) v.findViewById(R.id.tv_message);
        message.setText(model.getText());
        if (model.isAdmin()) {
            TextView adminName = (TextView) v.findViewById(R.id.tv_name);
            adminName.setText(model.getName());
        }
        return v;
    }
}
