package userkit.sdk.job;

import android.os.Parcel;
import android.util.Log;

import retrofit2.Response;
import userkit.sdk.Constants;
import userkit.sdk.api.ErrorHandler;
import userkit.sdk.api.ErrorResponse;
import userkit.sdk.api.ServiceGenerator;
import userkit.sdk.api.UserKitService;
import userkit.sdk.data.ProfileIdAliasPack;
import userkit.sdk.exception.ServerResponseCodeException;
import userkit.sdk.exception.UserProfileNullException;
import userkit.sdk.profile.UserProfile;

/**
 * Created by khangnt on 8/24/16.
 * Email: khang.neon.1997@gmail.com
 */
public class PostAliasIdJob extends JobBase {
    private static final String TAG = "PostAliasIdJob";
    private static final int MAX_RETRY_TIMES = 2;

    String aliasId;

    public PostAliasIdJob(String aliasId) {
        super(Priority.HIGH, JobGroup.ALIAS_ID);
        this.aliasId = aliasId;
    }

    public PostAliasIdJob(Parcel in) {
        super(in);
        this.aliasId = in.readString();
    }

    @Override
    protected void onRun() throws Throwable {
        UserProfile userProfile = UserProfile.getCurrentProfile();
        if (userProfile == null)
            throw new UserProfileNullException();
        String profileId = userProfile.getIdentifiedId();
        UserKitService userKitService = ServiceGenerator.retrofit(Constants.USER_KIT_CLIENT)
                .create(UserKitService.class);
        Response<Void> response = userKitService.mapProfileId(new ProfileIdAliasPack(profileId, aliasId)).execute();
        if (!response.isSuccessful()) {
            ErrorResponse errorResponse = ErrorHandler.parseError(response, Constants.USER_KIT_CLIENT);
            // Throw server response exception
            throw new ServerResponseCodeException(response.code(), errorResponse);
        } else
            Log.i(TAG, "Post alias id success.");
    }

    @Override
    protected int shouldRetryOnThrowException(Throwable exception, int runCount) {
        exception.printStackTrace();
        if (exception instanceof ServerResponseCodeException        //  Server response error, do not try again.
                || exception instanceof UserProfileNullException)   //  User profile = null
            return -1;
        return runCount - 1 < MAX_RETRY_TIMES ? 3000 : -1;
    }

    @Override
    public boolean canMergeJob(JobBase job) {
        return false;
    }

    @Override
    public void writeToParcel(Parcel out) {
        out.writeString(aliasId);
    }
}
