package userkit.sdk.job;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by khangnt on 8/23/16.
 * Email: khang.neon.1997@gmail.com
 */
public class JobQueue implements Parcelable {

    final Object lock = new Object();

    List<JobBase> jobList;

    public JobQueue() {
        jobList = new ArrayList<>();
    }

    public JobQueue(Parcel in) {
        this();
        int jobCount = in.readInt();
        for (int i = 0; i < jobCount; i++) {
            int jobGroup = in.readInt();
            switch (jobGroup) {
                case JobGroup.EVENT_GROUP:
                    jobList.add(new PostEventJob(in));
                    break;
                case JobGroup.PROFILE_GROUP:
                    jobList.add(new PostProfileJob(in));
                    break;
            }
        }
    }

    public int getJobCount() {
        synchronized (lock) {
            return jobList.size();
        }
    }

    public JobBase getJob(int index) {
        return jobList.get(index);
    }

    public void addJob(JobBase job) {
        synchronized (lock) {
            for (int i = 0; i < jobList.size(); i++) {
                if (getJob(i).getPriority() <= job.getPriority()) {
                    for (int k = i; k < jobList.size(); k++) {
                        if (getJob(k).getPriority() == job.getPriority()) {
                            if (getJob(k).getGroupId() == job.getGroupId()) {
                                if (getJob(k).canMergeJob(job))
                                    return;
                            }
                        } else {
                            jobList.add(k, job);
                            return;
                        }
                    }
                    jobList.add(job);
                    return;
                }
            }
            jobList.add(job);
        }
    }

    public void removeTopQueue() {
        synchronized (lock) {
            if (jobList.size() > 0)
                jobList.remove(0);
        }
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(jobList.size());
        for (JobBase jobBase : jobList) {
            parcel.writeInt(jobBase.getGroupId());
            jobBase.writeToParcel(parcel);
        }
    }

    public static final Creator<JobQueue> CREATOR = new Creator<JobQueue>() {
        @Override
        public JobQueue createFromParcel(Parcel in) {
            return new JobQueue(in);
        }

        @Override
        public JobQueue[] newArray(int size) {
            return new JobQueue[size];
        }
    };
}
