package userkit.sdk.job;

import android.os.Parcel;

/**
 * Created by khangnt on 8/23/16.
 * Email: khang.neon.1997@gmail.com
 */
public abstract class JobBase {
    int priority = 0;
    int groupId = 0;

    boolean running = false;

    public JobBase(int priority, int groupId) {
        this.priority = priority;
        this.groupId = groupId;
    }

    protected JobBase(Parcel in) {
    }


    public boolean isRunning() {
        return running;
    }

    public int getGroupId() {
        return groupId;
    }

    public int getPriority() {
        return priority;
    }

    public void run() throws Throwable {
        running = true;
        int runCount = 0;
        int delayStart = 0;
        while (true) {
            ++runCount;
            try {
                if (delayStart > 0)
                    Thread.sleep(delayStart);
                onRun();
                break;
            } catch (InterruptedException ignore) {

            } catch (Throwable t) {
                delayStart = shouldRetryOnThrowException(t, runCount);
                if (delayStart < 0)
                    throw t;
            }
        }
        running = false;
    }

    protected abstract void onRun() throws Throwable;

    protected abstract int shouldRetryOnThrowException(Throwable exception, int runCount);

    public abstract boolean canMergeJob(JobBase job);

    public abstract void writeToParcel(Parcel out);
}
