package userkit.sdk.api;


import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import userkit.sdk.Properties;
import userkit.sdk.data.EventsPack;
import userkit.sdk.data.ProfileIdAliasPack;
import userkit.sdk.data.ProfileUpdatePack;
import userkit.sdk.data.TokenUpdatePack;

/**
 * Created by khangnt on 8/12/16.
 * Email: khang.neon.1997@gmail.com
 */
public interface UserKitService {
    @POST("events/bulk")
    Call<Void> postEvents(@Body EventsPack body);

    @PUT
    Call<Void> profileUpdate(@Url String endPointUrl, @Body ProfileUpdatePack body);

    @POST("alias")
    Call<Void> mapProfileId(@Body ProfileIdAliasPack body);

    @POST("profile/token")
    Call<Void> updateGCMToken(@Body TokenUpdatePack body);

    @GET("profile/properties")
    Call<Properties> getProperties(@Query("profile_id") String profileId, @Query("keys") String keys);
}
