package userkit.sdk.api;

import java.io.IOException;
import java.lang.annotation.Annotation;

import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;

/**
 * Created by khangnt on 8/24/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ErrorHandler {
    public static ErrorResponse parseError(Response<?> response, String baseUrl) {
        Converter<ResponseBody, ErrorResponse> converter =
                ServiceGenerator.retrofit(baseUrl)
                        .responseBodyConverter(ErrorResponse.class, new Annotation[0]);
        ErrorResponse error;

        try {
            error = converter.convert(response.errorBody());
        } catch (IOException e) {
            return new ErrorResponse("Unknown error message");
        }
        return error;
    }
}
