package userkit.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;

import retrofit2.Callback;
import userkit.sdk.api.ServiceGenerator;
import userkit.sdk.api.UserKitService;
import userkit.sdk.data.TokenUpdatePack;
import userkit.sdk.exception.UserProfileNullException;
import userkit.sdk.profile.UserProfile;

/**
 * Created by khangnt on 8/15/16.
 * Email: khang.neon.1997@gmail.com
 */
public class UserKit {
    public static Boolean DEBUG = false;
    public static final String USER_KIT_API_TOKEN = "USER_KIT_API_TOKEN";
    public static final String TAG = "UserKit";
    private Context context;
    private String apiToken;

    private UserKit(Context context) {
        this.context = context.getApplicationContext();
    }

    private static UserKit singleInstance;

    public synchronized static void init(Context context) {
        init(context, null);
    }

    public synchronized static void init(Context context, String apiToken) {
        if (singleInstance == null)
            singleInstance = new UserKit(context);
        if (apiToken != null)
            singleInstance.setApiToken(apiToken);
        else { // Find api token from manifest meta data
            ApplicationInfo ai = null;
            try {
                ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                apiToken = bundle.getString(USER_KIT_API_TOKEN);
                singleInstance.setApiToken(apiToken);
            } catch (PackageManager.NameNotFoundException ignore) {
                Log.w(TAG, "Warning: You haven't set API Token");
            }
        }
    }


    public static UserKit getInstance() {
        if (singleInstance == null)
            throw new IllegalStateException("Call UserKit.init() first!");
        return singleInstance;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getApiToken() {
        return apiToken;
    }

    public Context getContext() {
        return context;
    }

    public void postGCMToken(String token, Callback<Void> callback) {
        UserKitService userKitService = ServiceGenerator.retrofit(Constants.USER_KIT_CLIENT)
                .create(UserKitService.class);

        UserProfile userProfile = UserProfile.getCurrentProfile();
        if (userProfile == null)
            throw new UserProfileNullException();
        userKitService.updateGCMToken(new TokenUpdatePack(userProfile.getIdentifiedId(), token))
                .enqueue(callback);
    }

    public static void setDebugConfiguration(boolean isDebug) {
        DEBUG = isDebug;
    }
}
