package userkit.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.util.AbstractList;
import java.util.HashMap;

/**
 * Created by khangnt on 8/23/16.
 * Email: khang.neon.1997@gmail.com
 */
public class Properties extends HashMap<String, Object> implements Parcelable {

    public Properties() {
    }

    public Properties(HashMap<String, Object> data) {
        super(data);
    }


    protected Properties(Parcel in) {
        String dataJson = in.readString();
        HashMap<String, Object> data = new Gson().fromJson(dataJson, new TypeToken<HashMap<String, Object>>() {
        }.getType());
        putAll(data);
    }

    /**
     * Add or replace a property value with type <tt>String</tt>.
     *
     * @param name  property name.
     * @param value property value or null.
     * @return current instance.
     */
    public Properties putProperty(String name, @Nullable String value) {
        put(name, value);
        return this;
    }

    /**
     * Add or replace a property value with type <tt>Number</tt>.
     *
     * @param name  property name
     * @param value property value or null.
     * @return current instance.
     */
    public Properties putProperty(String name, @Nullable Number value) {
        put(name, value);
        return this;
    }

    /**
     * Add or replace a property value with type <tt>Boolean</tt>.
     *
     * @param name  property name
     * @param value property value or null.
     * @return current instance.
     */
    public Properties putProperty(String name, @Nullable Boolean value) {
        put(name, value);
        return this;
    }

    public Properties putProperty(String name, @Nullable Object... value) {
        if (value != null)
            for (Object element : value)
                if (element != null
                        && !(element instanceof String)
                        && !(element instanceof Boolean)
                        && !(element instanceof Number))
                    throw new RuntimeException("Can not add this type value: " + element.getClass());
        put(name, value);
        return this;
    }

    public Properties putProperty(String name, @Nullable AbstractList<Object> value) {
        if (value != null)
            for (Object element : value)
                if (element != null
                        && !(element instanceof String)
                        && !(element instanceof Boolean)
                        && !(element instanceof Number))
                    throw new RuntimeException("Can not add this type value: " + element.getClass());
        put(name, value);
        return this;
    }

    public String getPropertyString(String name) {
        return ((String) get(name));
    }

    public Number getPropertyNumber(String name) {
        return ((Number) get(name));
    }

    public Boolean getPropertyBoolean(String name) {
        return ((Boolean) get(name));
    }

    public <T extends AbstractList<Object>> T getPropertyList(String name) {
        //noinspection unchecked
        return ((T) get(name));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        String dataJson = new Gson().toJson(this);
        parcel.writeString(dataJson);
    }

    public static final Creator<Properties> CREATOR = new Creator<Properties>() {
        @Override
        public Properties createFromParcel(Parcel in) {
            return new Properties(in);
        }

        @Override
        public Properties[] newArray(int size) {
            return new Properties[size];
        }
    };

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
