package userkit.sdk.identity.data;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;


/**
 * Created by khangnt on 8/23/16.
 * Email: khang.neon.1997@gmail.com
 */
public class SignUpData extends JSONObject {
    public static final String EMAIL = "email";
    public static final String PASSWORD = "password";
    public static final String PROFILES = "profiles";

    public SignUpData(String email, String password) throws JSONException {
        put(EMAIL, email);
        put(PASSWORD, password);
    }

    public SignUpData(String email, String password, JSONArray profiles) throws JSONException {
        this(email, password);
        put(PROFILES, profiles);
    }

    public SignUpData(String email, String password, List<JSONObject> profiles) throws JSONException {
        this(email, password);
        JSONArray jsonArray = new JSONArray();
        for (JSONObject profile : profiles) {
            jsonArray.put(profile);
        }
        put(PROFILES, jsonArray);
    }

    public String getEmail() {
        try {
            return getString(EMAIL);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getPassword() {
        try {
            return getString(PASSWORD);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public JSONArray getProfiles() {
        try {
            return getJSONArray(PROFILES);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }
}
