package userkit.sdk.identity.data;

import android.util.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;


/**
 * Created by khangnt on 8/23/16.
 * Email: khang.neon.1997@gmail.com
 */
public class LoginResponse extends JSONObject {
    public static final String NEW = "new";
    public static final String TOKEN = "token";
    public static final String PROFILES = "profiles";

    public LoginResponse(String json) throws JSONException {
        super(json);
        Log.d("LOGIN", "LoginResponse: " + json);
    }

    public String getToken() {
        try {
            return getString(TOKEN);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isNewAccount() {
        try {
            return getBoolean(NEW);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return true;
    }

    public List<JSONObject> getProfiles() {
        List<JSONObject> profiles = null;
        try {
            JSONArray jsonArray = getJSONArray(PROFILES);
            profiles = new ArrayList<>();
            for (int i = 0; i < jsonArray.length(); i++) {
                profiles.add(jsonArray.getJSONObject(i));
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return profiles;
    }
}
