package userkit.sdk.identity.api;

import android.support.annotation.NonNull;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import userkit.sdk.identity.UserKitIdentity;

public class ServiceGenerator {
    private static IdentityService sIdentityService;
    private static ProfilesService sProfilesService;

    public static IdentityService buildIdentityService(String baseUrl) {
        if (sIdentityService == null)
            sIdentityService = retrofit(baseUrl, new ApiTokenInterceptor())
                    .create(IdentityService.class);
        return sIdentityService;
    }

    public static ProfilesService buildProfilesService(String baseUrl) {
        if (sProfilesService == null)
            sProfilesService = retrofit(baseUrl, new AuthTokenInterceptor())
                    .create(ProfilesService.class);
        return sProfilesService;
    }

    @NonNull
    private static Retrofit retrofit(String baseUrl, Interceptor interceptor) {
        return new Retrofit.Builder()
                .baseUrl(baseUrl)
                .client(new OkHttpClient.Builder().addInterceptor(interceptor).build())
                .addConverterFactory(GsonConverterFactory.create())
                .build();
    }

    private static class ApiTokenInterceptor implements Interceptor {

        @Override
        public Response intercept(Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithHeaders = originalRequest.newBuilder()
                    .header("Content-Type", "application/json")
                    .header("X-USERKIT-TOKEN", UserKitIdentity.getApiToken())
                    .build();
            return chain.proceed(requestWithHeaders);
        }
    }

    private static class AuthTokenInterceptor implements Interceptor {
        @Override
        public Response intercept(Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithHeaders = originalRequest.newBuilder()
                    .header("Content-Type", "application/json")
                    .header("X-USERKIT-TOKEN", UserKitIdentity.getAuthToken())
                    .build();
            return chain.proceed(requestWithHeaders);
        }
    }
}