package userkit.sdk.identity.api;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import userkit.sdk.identity.data.SignInEmailPasswordData;
import userkit.sdk.identity.data.SignInSocialData;

/**
 * Created by khangnt on 8/23/16.
 * Email: khang.neon.1997@gmail.com
 */
public interface IdentityService {

    @POST("auth/signup")
    Call<ResponseBody> signUp(@Body RequestBody body);

    @POST("auth/signin")
    Call<ResponseBody> signInEmailPassword(@Body SignInEmailPasswordData body);

    @POST("auth/facebook")
    Call<ResponseBody> signInFacebook(@Body SignInSocialData body);

    @POST("auth/google")
    Call<ResponseBody> signInGoogle(@Body SignInSocialData body);

}
