package userkit.sdk.identity.api;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import userkit.sdk.identity.callback.ICallback;
import userkit.sdk.identity.exception.ServerResponseException;

/**
 * Created by khangnt on 8/30/16.
 * Email: khang.neon.1997@gmail.com
 */
public class HandleResponse {

    public static <T> void enqueueCallback(Call<T> call, final ICallback<T> callback) {
        call.enqueue(new Callback<T>() {
            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful())
                    callback.onResponse(response.body());
                else
                    onFailure(call, new ServerResponseException(new ErrorResponse(response)));
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                callback.onError(t);
            }
        });
    }

    public static <T, V> void enqueueCallback(Call<T> call, final ICallback<V> callback, final Transformer<T, V> transformer) {
        call.enqueue(new Callback<T>() {
            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful()) {
                    try {
                        callback.onResponse(transformer.transform(response.body()));
                    } catch (Exception e) {
                        e.printStackTrace();
                        onFailure(call, e);
                    }
                } else
                    onFailure(call, new ServerResponseException(new ErrorResponse(response)));
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                callback.onError(t);
            }
        });
    }
}
