package userkit.sdk.identity.api;

import org.json.JSONObject;

import retrofit2.Response;

/**
 * Created by khangnt on 8/24/16.
 * Email: khang.neon.1997@gmail.com
 */
public class ErrorResponse {
    private int code;
    private String message;
    private String errorMessage;

    public ErrorResponse(Response response) {
        this.code = response.code();
        this.message = response.message();
        try {
            this.errorMessage = new JSONObject(response.errorBody().string()).getString("message");
        } catch (Throwable ignore) {
            this.errorMessage = "Unknown error";
        }
    }

    public ErrorResponse(String message) {
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public String toString() {
        return "Response: " + getCode() + " - " + getMessage()
                + "\nError message: " + getErrorMessage();
    }
}
