/*
 * Decompiled with CFR 0.152.
 */
package uschi2000.paths;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class Path
implements Comparable<Path> {
    public static final Path ROOT_PATH = new Path((List<String>)ImmutableList.of(), true, true);
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = "/";
    public static final String BACKWARDS_PATH = "..";
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    static final Joiner PATH_JOINER = Joiner.on((char)'/');
    private static final char[] ILLEGAL_CHARS = new char[]{'\u0000'};
    private static final List<String> ILLEGAL_SEGMENTS = ImmutableList.of((Object)".");
    private final List<String> segments;
    private final int size;
    private final boolean isAbsolute;
    private final boolean isFolder;
    private final Supplier<String> stringRepresentation;
    private final Supplier<Path> normalizedPath;

    private Path(List<String> segments, boolean isAbsolute, boolean isFolder) {
        this.segments = segments;
        this.size = segments.size();
        this.isAbsolute = isAbsolute;
        this.isFolder = isFolder;
        this.stringRepresentation = Suppliers.memoize((Supplier)new Supplier<String>(){

            public String get() {
                return Path.this.toStringInternal();
            }
        });
        this.normalizedPath = Suppliers.memoize((Supplier)new Supplier<Path>(){

            public Path get() {
                return Path.this.normalizeInternal();
            }
        });
    }

    Path(String input) {
        this(Path.checkAndSplit(input), input.startsWith(SEPARATOR), input.endsWith(SEPARATOR));
    }

    private static List<String> checkAndSplit(String path) {
        return Path.checkSegments((List<String>)ImmutableList.copyOf((Iterable)PATH_SPLITTER.split((CharSequence)Path.checkCharacters(path))));
    }

    private static String checkCharacters(String path) {
        if (StringUtils.containsAny((CharSequence)path, (char[])ILLEGAL_CHARS)) {
            throw new IllegalArgumentException("Path contains illegal characters: " + path);
        }
        return path;
    }

    private static List<String> checkSegments(List<String> segments) {
        if (!Collections.disjoint(segments, ILLEGAL_SEGMENTS)) {
            throw new IllegalArgumentException("Path contains illegal segments: " + segments);
        }
        return segments;
    }

    private Path normalizeInternal() {
        LinkedList normalSegments = Lists.newLinkedList();
        for (String segment : this.segments) {
            if (segment.equals(BACKWARDS_PATH)) {
                if (normalSegments.isEmpty()) continue;
                normalSegments.removeLast();
                continue;
            }
            normalSegments.add(segment);
        }
        return new Path(normalSegments, this.isAbsolute, this.isFolder);
    }

    public Path normalize() {
        return (Path)this.normalizedPath.get();
    }

    public Path getRoot() {
        if (this.size > 0 && this.isAbsolute) {
            return ROOT_PATH;
        }
        return null;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public Path getFileName() {
        Path normal = this.normalize();
        if (normal.segments.isEmpty()) {
            return null;
        }
        if (normal.size == 1 && !normal.isAbsolute) {
            return this;
        }
        return new Path(normal.segments.get(normal.size - 1));
    }

    public Path getParent() {
        Path normal = this.normalize();
        if (normal.size == 0) {
            return null;
        }
        if (normal.size == 1) {
            return this.getRoot();
        }
        return new Path(normal.segments.subList(0, normal.size - 1), normal.isAbsolute, true);
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public Path resolve(Path other) {
        if (other.isAbsolute) {
            return other;
        }
        return new Path((List<String>)ImmutableList.copyOf((Iterable)Iterables.concat(this.segments, other.segments)), this.isAbsolute, other.isFolder);
    }

    public Path resolve(String other) {
        return this.resolve(new Path(other));
    }

    public Path relativize(Path other) {
        Path left = this.normalize();
        Path right = other.normalize();
        if (left.isAbsolute() != right.isAbsolute()) {
            throw new IllegalArgumentException("Cannot relativize absolute vs relative path: " + left + " vs " + right);
        }
        if (left.segments.size() > right.segments.size() || !left.segments.equals(right.segments.subList(0, left.size))) {
            throw new IllegalArgumentException("Relativize requires this path to be a prefix of the other path: " + left + " vs " + right);
        }
        if (left.size == 0 && !left.isAbsolute) {
            return right;
        }
        return new Path(right.segments.subList(left.size, right.size), false, right.isFolder);
    }

    public Path relativize(String other) {
        return this.relativize(new Path(other));
    }

    public boolean startsWithSegment(Path other) {
        Path left = this.normalize();
        Path right = other.normalize();
        if (left.size < right.size) {
            return false;
        }
        if (left.isAbsolute != right.isAbsolute) {
            return false;
        }
        return left.toString().startsWith(right.toString());
    }

    public boolean endsWithSegment(Path other) {
        Path left = this.normalize();
        Path right = other.normalize();
        if (left.size < right.size) {
            return false;
        }
        if (left.size == right.size) {
            if (!left.isAbsolute() && right.isAbsolute) {
                return false;
            }
            return left.segments.equals(right.segments);
        }
        if (right.isAbsolute) {
            return false;
        }
        return left.segments.subList(left.size - right.size, left.size).equals(right.segments);
    }

    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return ROOT_PATH.resolve(this);
    }

    @Override
    public int compareTo(Path other) {
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object ob) {
        if (ob != null && ob instanceof Path) {
            return this.compareTo((Path)ob) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])this.segments.toArray());
    }

    private String toStringInternal() {
        if (this.size == 0) {
            return this.isAbsolute ? SEPARATOR : "";
        }
        String prefix = this.isAbsolute ? SEPARATOR : "";
        String suffix = this.isFolder ? SEPARATOR : "";
        return prefix + PATH_JOINER.join(this.segments) + suffix;
    }

    public String toString() {
        return (String)this.stringRepresentation.get();
    }
}

