/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collections;
import universum.studios.android.widget.adapter.BaseListAdapter;
import universum.studios.android.widget.adapter.holder.AdapterHolder;
import universum.studios.android.widget.adapter.holder.ViewHolder;

public abstract class BaseSpinnerAdapter<A extends BaseSpinnerAdapter, VH extends ViewHolder, DVH extends ViewHolder, I>
extends BaseListAdapter<A, VH, I> {
    private int selectedPosition = -1;
    private AdapterHolder.Factory<DVH> dropDownHolderFactory;
    private AdapterHolder.Binder<A, DVH> dropDownHolderBinder;

    public BaseSpinnerAdapter(@NonNull Context context) {
        super(context);
    }

    public void setDropDownHolderFactory(@Nullable AdapterHolder.Factory<DVH> factory) {
        this.dropDownHolderFactory = factory;
    }

    @Nullable
    public AdapterHolder.Factory<DVH> getDropDownHolderFactory() {
        return this.dropDownHolderFactory;
    }

    public void setDropDownHolderBinder(@Nullable AdapterHolder.Binder<A, DVH> binder) {
        this.dropDownHolderBinder = binder;
    }

    @Nullable
    public AdapterHolder.Binder<A, DVH> getDropDownHolderBinder() {
        return this.dropDownHolderBinder;
    }

    @Nullable
    public I getSelectedItem() {
        return (I)(this.selectedPosition == -1 ? null : this.getItem(this.selectedPosition));
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        this.selectedPosition = position;
        return super.getView(this.selectedPosition, convertView, parent);
    }

    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewHolder viewHolder;
        View view = convertView;
        if (view == null) {
            viewHolder = this.onCreateDropDownViewHolder(parent, this.getItemViewType(position));
            view = viewHolder.itemView;
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        viewHolder.updateAdapterPosition(position);
        this.onBindDropDownViewHolder(viewHolder, position);
        return view;
    }

    @NonNull
    protected DVH onCreateDropDownViewHolder(@NonNull ViewGroup parent, int viewType) {
        return (DVH)(this.dropDownHolderFactory == null ? this.onCreateViewHolder(parent, viewType) : (ViewHolder)this.dropDownHolderFactory.createHolder(parent, viewType));
    }

    protected void onBindDropDownViewHolder(@NonNull DVH viewHolder, int position) {
        if (this.dropDownHolderBinder == null) {
            this.onBindViewHolder(viewHolder, position);
        } else {
            this.dropDownHolderBinder.bindHolder(this, viewHolder, position, Collections.EMPTY_LIST);
        }
    }
}

